/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ValueReferenceResolver;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

public interface UsersListResolver {
    public static final String SPECIAL_VALUE_REFERENCES = "@author@, @poster@, @creator@, @modifier@";

    public ConfluenceUser[] getValueAsUsers(ValueReferenceResolver var1, AbstractPage var2, String var3) throws WorkflowException;

    public ConfluenceUser[] getValueAsUsers(ValueReferenceResolver var1, AbstractPage var2, String var3, boolean var4) throws WorkflowException;

    public ConfluenceUser[] getValueAsUsers(ValueReferenceResolver var1, AbstractPage var2, String var3, boolean var4, boolean var5) throws WorkflowException;

    public String[] getValueAsUserNames(ValueReferenceResolver var1, AbstractPage var2, String var3, boolean var4) throws WorkflowException;

    public String[] getValueAsUserKeys(ValueReferenceResolver var1, AbstractPage var2, String var3) throws WorkflowException;

    public UserGroupResolved getUsersGroupsResolved(ValueReferenceResolver var1, AbstractPage var2, String var3, boolean var4) throws WorkflowException;

    public UserGroupResolved getUsersGroupsResolvedPreserveType(String var1, String var2) throws WorkflowException;

    public Collection<Entity> getValueAsUsersOrGroups(ValueReferenceResolver var1, String var2) throws WorkflowException;

    public List<Group> getValueAsGroups(ValueReferenceResolver var1, String var2) throws WorkflowException;

    public List<ConfluenceUser> getAsUsers(String var1);

    public void checkUsers(String var1) throws WorkflowException;

    public String valueReferenceToWiki(String var1) throws WorkflowException;

    public String usersReferenceToWiki(ValueReferenceResolver var1, String var2, String var3) throws WorkflowException;

    public UsersReference makeUsersReference(String var1);

    public UsersReference makeGroupsReference(String var1);

    public void validateReference(ValueReferenceResolver var1, String var2, boolean var3, boolean var4) throws WorkflowException;

    public List<String> getUsersFromGroup(String var1, Integer var2) throws WorkflowException;

    public int getMaxHandledUsers();

    public void throwMaxHandledUsersLimitReachedError() throws WorkflowUserException;

    public static enum ResolverErrorHandling {
        EXCEPTION_ALL("exception_all"),
        EXCEPTION_RESOLVER("exception_resolver"),
        ERROR_LOG("error_log"),
        IGNORE("ignore"),
        PRESERVE_UNRESOLVED_AS_USERS("user"),
        PRESERVE_UNRESOLVED_AS_GROUPS("group");

        public static ResolverErrorHandling DEFAULT;
        private static final Map<String, ResolverErrorHandling> FORMAT_MAP;
        private final String formatted;

        private ResolverErrorHandling(String formatted) {
            this.formatted = formatted;
        }

        @JsonCreator
        public static ResolverErrorHandling fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        static {
            DEFAULT = EXCEPTION_RESOLVER;
            FORMAT_MAP = Stream.of(ResolverErrorHandling.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }

    public static interface Config {
        public boolean isExpandGroupMembers();

        public boolean isIgnoreUserLimit();

        public ResolverErrorHandling getErrorHandling();

        public boolean isIgnoreResolverExceptions();

        public boolean isIgnoreAllExceptions();

        public boolean isRestrictionsMacro();
    }

    public static interface UserGroupResolved {
        public List<ConfluenceUser> getUsersOnly();

        public List<Group> getGroupsOnly();

        public Map<String, ConfluenceUser> getUsersOnlyMap();

        public Map<String, Group> getGroupsOnlyMap();

        public List<ConfluenceUser> getUsersIncludingGroupMembers();

        public Map<String, ConfluenceUser> getUsersMapIncludingGroupMembers();

        public Collection<Entity> getLinkedUsersAndGroups();
    }

    public static class UsersReference {
        String usersList;
        String groupsList;

        public UsersReference(List<String> usersList, List<String> groupsList) {
            String[] usersArr = new String[usersList.size()];
            String[] groupsArr = new String[groupsList.size()];
            this.usersList = MiscUtils.stringListToCommaSeparatedList(usersList.toArray(usersArr), ",");
            this.groupsList = MiscUtils.stringListToCommaSeparatedList(groupsList.toArray(groupsArr), ",");
        }

        public String getUsersList() {
            return this.usersList;
        }

        public String getGroupsList() {
            return this.groupsList;
        }
    }
}

