/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.util.MiscUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class Assignment
extends Activity
implements com.comalatech.workflow.model.Assignment {
    private String assignee;
    @Nullable
    private String rolename;
    private String groups;
    private Date dueDate;

    public Assignment() {
    }

    public Assignment(String performer, Date date, String assignee, String rolename, String groups, Date dueDate) {
        super(performer, date);
        this.assignee = assignee;
        this.rolename = rolename;
        this.groups = groups;
        this.dueDate = dueDate;
    }

    @Nullable
    public String getRolename() {
        return this.rolename;
    }

    public void setRolename(@Nullable String rolename) {
        this.rolename = rolename;
    }

    public String getAssignerAndAssignees() {
        if (!StringUtils.isNotBlank((CharSequence)this.assignee)) {
            return this.getPerformer();
        }
        return this.assignee + "," + this.getPerformer();
    }

    public String getGroups() {
        return this.groups;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    public boolean isUserAssigned(String userName) {
        return this.assignee != null && this.assignee.equalsIgnoreCase(userName);
    }

    public List<String> getGroupNames() {
        return new ArrayList<String>(Arrays.asList(MiscUtils.splitAndTrim(this.groups)));
    }

    public String getAssigneeNames() {
        StringBuffer sb = new StringBuffer();
        String separator = "";
        if (StringUtils.isNotBlank((CharSequence)this.assignee)) {
            sb.append(this.assignee);
            separator = ",";
        }
        for (String group : MiscUtils.splitAndTrim(this.groups)) {
            sb.append(separator).append(group);
            separator = ",";
        }
        return sb.toString();
    }

    public boolean hasAssignees() {
        return StringUtils.isNotBlank((CharSequence)this.assignee) || StringUtils.isNotBlank((CharSequence)this.groups);
    }

    public boolean isSimilar(Assignment that) {
        if (that == null) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        return Objects.equals(this.assignee, that.assignee);
    }

    public void syncDueDateTime() {
        if (this.dueDate == null) {
            return;
        }
        DateTime newDueDate = new DateTime(this.dueDate);
        this.dueDate = newDueDate.plusMillis(new DateTime(this.getDate()).getMillisOfDay()).toDate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Assignment that = (Assignment)o;
        if (!Objects.equals(this.dueDate, that.dueDate)) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        return Objects.equals(this.assignee, that.assignee);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.assignee != null ? this.assignee.hashCode() : 0);
        result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
        result = 31 * result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
        return result;
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.dueDate != null) {
            map.put("duedate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z").format(this.dueDate));
        }
        return map;
    }

    @Override
    public String getActivityKey() {
        return "assignment";
    }

    @Override
    public String getActivityId() {
        return "0";
    }

    @Override
    @Deprecated
    public List<String> getAssigneesUserNames() {
        return Collections.singletonList(this.getAssignee());
    }

    @Override
    public String toString() {
        return "assignee: " + this.getAssignee() + ", assigned groups: " + this.getGroups() + ", assigned " + Activity.toString(this);
    }
}

