/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.statistics.accessor.builder;

import com.comalatech.confluence.documentActivity.statistics.accessor.builder.WorkflowStatsFilterBuilder;
import com.comalatech.confluence.documentActivity.statistics.accessor.criteria.WorkflowStatsSearchCriteria;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class SpaceFilterBuilder
implements WorkflowStatsFilterBuilder {
    @Override
    public Query build(WorkflowStatsSearchCriteria criteria) {
        if (Objects.isNull(criteria) || criteria.getSpaceIds() == null || criteria.getSpaceIds().isEmpty()) {
            return null;
        }
        String queryClause = "";
        List<Long> spaceIds = criteria.getSpaceIds();
        if (spaceIds.size() == 1) {
            queryClause = queryClause + "SPACE_ID= ?";
        } else {
            String placeHolders = spaceIds.stream().map(s -> "?").collect(Collectors.joining(","));
            queryClause = queryClause + "SPACE_ID IN (" + placeHolders + ")";
        }
        return Query.select().where(queryClause, spaceIds.toArray());
    }
}

