/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.model;

import com.comalatech.confluence.adhoc.notification.model.Notification;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import org.springframework.web.util.HtmlUtils;

public class ReadAckCreatedOverdueNotification
extends Notification {
    public static final String PAGE_TITLE_KEY = "pageTitle";
    public static final String PAGE_PATH_KEY = "pagePath";

    @Override
    public String getSubject() {
        return HtmlUtils.htmlEscape((String)ComalaI18nBean.getComalaI18nBean().getText("readack.notification.duedate.expired.subject", new String[]{(String)this.getContextProperties().get(PAGE_TITLE_KEY)}));
    }

    @Override
    public String getTemplateName() {
        return "read-ack-overdue";
    }

    @Override
    public String getBody(Notification.MessageSystem notificationMessageSystem) {
        String path = this.getBaseUrl() + this.getContextProperties().get(PAGE_PATH_KEY).toString();
        String title = this.getContextProperties().get(PAGE_TITLE_KEY).toString();
        switch (notificationMessageSystem) {
            case EMAIL: {
                String description = (String)this.getContextProperties().get("activityDescription");
                return HtmlUtils.htmlEscape((String)ComalaI18nBean.getComalaI18nBean().getText(description, new String[]{path, title}));
            }
            case SLACK: {
                String description = (String)this.getContextProperties().get("slackActivityDescription");
                return ComalaI18nBean.getComalaI18nBean().getText(description, new String[]{path, title});
            }
        }
        throw new IllegalArgumentException("Type notification not valid");
    }
}

