/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.ApprovalAssignedNotification;
import com.comalatech.confluence.adhoc.notification.model.Notification;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.WorkflowsNotificationPublisher;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.workflow.event.approval.ApprovalAssignedEvent;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class ApprovalNotificationListener
extends WorkflowsListener {
    protected final WorkflowNotificationConfigManager workflowNotificationConfigManager;
    protected final AdhocNotificationService adhocNotificationService;
    protected final UserAccessor userAccessor;
    protected final WorkflowsNotificationPublisher workflowsNotificationPublisher;
    protected final DarkFeatureManager darkFeatureManager;

    public ApprovalNotificationListener(EventPublisher eventPublisher, WorkflowNotificationConfigManager workflowNotificationConfigManager, AdhocNotificationService adhocNotificationService, UserAccessor userAccessor, WorkflowsNotificationPublisher workflowsNotificationPublisher, DarkFeatureManager darkFeatureManager) {
        super(eventPublisher);
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
        this.adhocNotificationService = adhocNotificationService;
        this.userAccessor = userAccessor;
        this.workflowsNotificationPublisher = workflowsNotificationPublisher;
        this.darkFeatureManager = darkFeatureManager;
    }

    @EventListener
    public void pageApprovalAssignedEvent(PageApprovalAssignedEvent event) {
        this.processAssignedEvent(event);
    }

    @EventListener
    public void blogPostApprovalAssignedEvent(BlogPostApprovalAssignedEvent event) {
        this.processAssignedEvent(event);
    }

    protected void processAssignedEvent(ApprovalAssignedEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.APPROVAL_ASSIGNMENT, page.getSpaceKey())) {
            String assignee = event.getAssignment().getAssignee();
            ConfluenceUser assigneeUser = null;
            String assigneeKey = null;
            if (StringUtils.isNotBlank((CharSequence)assignee)) {
                assigneeUser = this.userAccessor.getUserByName(assignee);
                assigneeKey = assigneeUser.getKey().getStringValue();
            }
            ApprovalAssignedNotification notification = this.composeEmail(page, event, assigneeUser);
            this.workflowsNotificationPublisher.publish(notification.getSubject(), notification.getBody(Notification.MessageSystem.SLACK), assigneeKey, page);
            HashSet<ConfluenceUser> emailsTo = new HashSet<ConfluenceUser>();
            emailsTo.add(assigneeUser);
            this.adhocNotificationService.sendEmail(notification, emailsTo);
        }
    }

    private ApprovalAssignedNotification composeEmail(AbstractPage page, ApprovalAssignedEvent event, ConfluenceUser assigneeUser) {
        ApprovalAssignedNotification notification = new ApprovalAssignedNotification();
        notification.setEntityId(page.getId());
        notification.addContextProperty("approvalName", event.getApprovalName());
        notification.addContextProperty("assignee", assigneeUser);
        notification.addContextProperty("pageTitle", page.getTitle());
        notification.addContextProperty("activityDescription", "com.comalatech.approval.notification.assigned.description");
        notification.addContextProperty("slackActivityDescription", "com.comalatech.approval.notification.slack.assigned.description");
        String comment = event.getAssignment().getComment();
        notification.addContextProperty("assignmentNoteHtml", StringUtils.isNotBlank((CharSequence)comment) ? HtmlUtils.htmlEscape((String)comment) : "");
        return notification;
    }
}

