/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
AWP.Model = AWP.Model || {};

AWP.Model.Workflow = Backbone.Model.extend({
    defaults : {
        pageId: 0,
        contextPath: "/",

        // approvals on the current state
        approvals:new AWP.Collection.Approvals(),

        // states to choose from, just an array of strings,
        // nothing fancy at this time
        states: [],

        taskable: false,
        activeTasks: 0
    },

    type: "workflow",

    hasParameters: function() {
        console.log('hasparam', this, (this.get("parameters") && this.get("parameters").length > 0))
        return (this.get("parameters") && this.get("parameters").length > 0);
    },
    
    hasWorkflow: function() {
        return this.get("currentState") != undefined;
    },


    hasStateSelection : function() {
        return this.get("states") && this.get("states").length > 0;
    },

    isInitParameters: function() {
        return this.get("initParameters");
    },

    /**
     * Page only has tasks, no workflow 
     */
    isHideStates : function() {
        return this.get("hideStates");
    },

    isActivityVisible : function() {
        return this.get("activityVisible");
    },

    isShowTasks: function() {
        return this.get("taskable") || this.get("activeTasks") > 0;
    }
});