/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};

Adhoc.Workflow = Adhoc.Workflow || {};

Adhoc.menuActions = Adhoc.menuActions || [];

/**
 * @deprecated
 */
(function ($) {


    Adhoc.Workflow.setState = function(pageStatus) {
        Adhoc.state = pageStatus;
        var workflowButton = $("#adhocWorkflowsLink");
        if(!pageStatus.stateName || pageStatus.publishedView){
            workflowButton.css("display","none");
        }else{
            workflowButton.addClass("workflow-state").css("display","block").css("visibility","inherit");
            workflowButton.attr('title', pageStatus.hoverDescription);
            $("#workflow-page-message").html("");
            
        }
        if (pageStatus.activeTasks > 0) {
            $("#adhocTasksLink").css("display","block");
            Adhoc.Tasks.generateTasksPopup(Adhoc.Tasks.dialog.find(".contents"),this,function() {});
        } else {
            $("#adhocTasksLink").hide();
        }

        if (pageStatus.taskable){
            $("#addPageTaskLink").removeClass("notTaskable");
            $("#addPageTaskLink").addClass("taskable");
            $("#taskable").val("true");
        }else{
            $("#addPageTaskLink").removeClass("taskable");
            $("#addPageTaskLink").addClass("notTaskable");
            $("#taskable").val("false");
        }
        
        $("#editPageWorkflowLink").css("display", "block");
        
        AWP.Embedded.Workflow.setState(pageStatus);
    };

    Adhoc.Workflow.refreshState = function() {
        $.ajax({
            type: "GET",
            cache: false,
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/state/" + AJS.params.pageId + "?publishedView=" + Adhoc.publishedView,
            success: function (pageStatus, textStatus, jqXHR) {
                if (jqXHR.status != 200) {
                    return;
                }
                
                AWP.Embedded.Workflow.setState(pageStatus);
                if (Adhoc.clickedApprovalId) {
                    $("#adhocWorkflowsLink").click();
                }
            },
            error: Adhoc.errorHandler
        });
        return false;
    };

    Adhoc.Workflow.stateAction = function() {
        var $form = $(this).parents("form");
        var stateRequest = {
            name: $form.hasClass("adhoc") ? $form.find("input.newstatename").val() : $form.find("select").val(),
            assignee: Adhoc.getAssignees($form),
            note: $form.find("textarea").val()
        };
        var action = $(this).attr("name");
        Adhoc.submitProgress($(this).parents(".adhoc"));
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/state/" + AJS.params.pageId + "/" + action,
            data: JSON.stringify(stateRequest),
            success: function (pageStatus, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    AWP.Embedded.Workflow.setState(pageStatus);
                }
                Adhoc.dialog.hide();
            },
            error: Adhoc.errorHandler
        });
        return false;
    };

    Adhoc.Workflow.assign = function() {
        var $form = $(this).parents("form");
        $form.addClass("assign");
        return false;
    };

    Adhoc.Workflow.unassign = function() {
        var $form = $(this).parents("form");
        $form.addClass("unassign");
        return false;
    };


    Adhoc.Workflow.doStateDialog = function(action, $contents) {
    
        var states = action.states;
        $contents.append(AJS.template.load("adhocworkflows-states").fill());
        
        for (i = 0; i < states.length; i++) {
            var state = { name: states[i] };
            $contents.find("select").append(AJS.template.load("adhocworkflows-state").fill(state));
        }
        if (action.adhoc) {
            $contents.find("select").append(AJS.template.load("adhocworkflows-state-adhoc").fill());
            $contents.find("select").change(function() {
                var $form = $(this).parents("form");
                var stateId = $(this).val();
                if (stateId == "0") {
                    $form.addClass("adhoc");
                } else {
                    $form.removeClass("adhoc");
                    $form.find("input.newstatename").val("");
                }
            });
        }
        $contents.find("form.state input[type='submit']").click(Adhoc.Workflow.stateAction);
        $contents.find(".cancel-dialog").click(Adhoc.doHidePopup);

        Adhoc.setPresetUsers($("#inline-dialog-adhocWorkflowsPopup .usersdropdown .aui-dropdown"),action.involvedUsers);
        $contents.find(".usersdropdown").dropDown("Standard");
        $contents.find("input.autocomplete-user").click(function() {
            var $form = $(this).parents("form");
            $form.find(".usersdropdown a.aui-dd-trigger").click();
        });
        AJS.Confluence.Binder.autocompleteUser();
        $contents.find("input.autocomplete-user").bind("selected.autocomplete-user",Adhoc.selectAssignee);
        $contents.find(".assign-page").click(Adhoc.Workflow.assign);
        if (action.assignee != undefined) {
            $contents.find("input[name='assignee']").attr("placeholder",$contents.find("input[name='assignee']").attr("placeholder2"));
            $contents.find("ol.assignees.assigned").append(AJS.template.load("adhocworkflows-assignee").fill(action.assignee))
        }
        $contents.find("ol.assignees.assigned .remove-assignee").click(Adhoc.Workflow.unassign);

        if(!action.pageAssignable){
            $("form.aui.state").addClass("unassignable");
        }else{
           $("form.aui.state").removeClass("unassignable");
        }

    }

})(AJS.$);
