/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.joda.time.DateTime;
import org.randombits.storage.Storage;
import org.randombits.storage.StorageEvent;
import org.randombits.storage.StorageException;
import org.randombits.storage.StorageListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStorage
implements Storage {
    private List<StorageListener> listeners;
    private Stack<String> boxNames;

    @Override
    public void closeBox() {
        if (this.boxNames == null || this.boxNames.size() == 0) {
            throw new StorageException("There are no more boxes to close.");
        }
        String name = this.boxNames.pop();
        this.fireBoxClosedEvent(name);
    }

    @Override
    public boolean getBoolean(String name, boolean def) {
        return this.getBoolean(name, (Boolean)def);
    }

    @Override
    public abstract Boolean getBoolean(String var1, Boolean var2);

    @Override
    public abstract Date getDate(String var1, Date var2);

    @Override
    public DateTime getDateTime(String name, DateTime def) {
        Date value = this.getDate(name, null);
        if (value == null) {
            return def;
        }
        return new DateTime(value);
    }

    @Override
    public double getDouble(String name, double def) {
        return this.getDouble(name, new Double(def));
    }

    @Override
    public abstract Double getDouble(String var1, Double var2);

    @Override
    public int getInteger(String name, int def) {
        return this.getInteger(name, new Integer(def));
    }

    @Override
    public abstract Integer getInteger(String var1, Integer var2);

    @Override
    public long getLong(String name, long def) {
        return this.getLong(name, new Long(def));
    }

    @Override
    public abstract Long getLong(String var1, Long var2);

    @Override
    public Object getObject(String name, Object def) {
        return this.getObject(name, def, Object.class);
    }

    @Override
    public abstract <T> T getObject(String var1, T var2, Class<T> var3);

    @Override
    public abstract List<?> getObjectList(String var1, List<?> var2);

    @Override
    public abstract String getString(String var1, String var2);

    @Override
    public abstract String[] getStringArray(String var1, String[] var2);

    @Override
    public Set<String> getStringSet(String name, Set<String> def) {
        String[] valueArray = this.getStringArray(name, null);
        if (valueArray == null || valueArray.length == 0) {
            return def;
        }
        HashSet<String> value = new HashSet<String>();
        value.addAll(Arrays.asList(valueArray));
        return value;
    }

    @Override
    public abstract boolean isReadOnly();

    @Override
    public String makePath() {
        return this.buildPath().toString();
    }

    @Override
    public String makePath(String name) {
        StringBuffer out = this.buildPath();
        if (out.length() > 0) {
            out.append('.');
        }
        out.append(name);
        return out.toString();
    }

    private StringBuffer buildPath() {
        StringBuffer out = new StringBuffer();
        if (this.boxNames != null) {
            for (String name : this.boxNames) {
                if (out.length() > 0) {
                    out.append('.');
                }
                out.append(name);
            }
        }
        return out;
    }

    @Override
    public abstract Set<String> nameSet();

    @Override
    public void openBox(String name) {
        if (this.boxNames == null) {
            this.boxNames = new Stack();
        }
        this.boxNames.push(name);
        this.fireBoxOpenedEvent(name);
    }

    @Override
    public void setBoolean(String name, boolean value) {
        this.setBoolean(name, (Boolean)value);
    }

    @Override
    public abstract void setBoolean(String var1, Boolean var2);

    @Override
    public abstract void setDate(String var1, Date var2);

    @Override
    public void setDateTime(String name, DateTime value) {
        this.setDate(name, value == null ? null : value.toDate());
    }

    @Override
    public void setDouble(String name, double value) {
        this.setDouble(name, new Double(value));
    }

    @Override
    public abstract void setDouble(String var1, Double var2);

    @Override
    public void setInteger(String name, int value) {
        this.setInteger(name, new Integer(value));
    }

    @Override
    public abstract void setInteger(String var1, Integer var2);

    @Override
    public void setLong(String name, long value) {
        this.setLong(name, new Long(value));
    }

    @Override
    public abstract void setLong(String var1, Long var2);

    @Override
    public abstract void setObject(String var1, Object var2);

    public abstract void setObjectList(String var1, List<?> var2);

    @Override
    public abstract void setString(String var1, String var2);

    @Override
    public abstract void setStringArray(String var1, String[] var2);

    @Override
    public void setStringSet(String name, Set<String> values) {
        this.checkReadOnly();
        String[] valuesArray = null;
        if (values != null) {
            valuesArray = new String[values.size()];
            valuesArray = values.toArray(valuesArray);
        }
        this.setStringArray(name, valuesArray);
    }

    protected void checkReadOnly() throws UnsupportedOperationException {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("This storage object is read-only");
        }
    }

    @Override
    public void addStorageListener(StorageListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<StorageListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeStorageListener(StorageListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireBoxOpenedEvent(String boxName) {
        if (this.listeners != null) {
            StorageEvent evt = new StorageEvent(this, boxName);
            for (StorageListener l : this.listeners) {
                l.boxOpened(evt);
            }
        }
    }

    protected void fireBoxClosedEvent(String boxName) {
        if (this.listeners != null) {
            StorageEvent evt = new StorageEvent(this, boxName);
            for (StorageListener l : this.listeners) {
                l.boxClosed(evt);
            }
        }
    }
}

