/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.criteria;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.CriteriaParser;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.param.BaseParameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CriterionParameter
extends BaseParameter<Criterion> {
    public CriterionParameter(String defaultValue, List<String> names) {
        super(defaultValue, names);
    }

    public CriterionParameter(String defaultValue, String ... names) {
        super(defaultValue, names);
    }

    public boolean matches(MacroInfo info, Object value) throws ParameterException {
        return this.matches(info, value, true);
    }

    public boolean matches(MacroInfo info, Object value, boolean defaultMatch) throws ParameterException {
        Criterion criterion = this.createCriterion(info);
        if (criterion != null) {
            return criterion.matches(value);
        }
        return defaultMatch;
    }

    protected abstract CriterionInterpreter createCriterionInterpreter(MacroInfo var1);

    public Criterion createCriterion(MacroInfo info) throws ParameterException {
        return (Criterion)this.findValue(info);
    }

    @Override
    protected final Criterion findObject(String parameter, MacroInfo info) throws ParameterException {
        return this.createCriterion(parameter, info);
    }

    protected Criterion createCriterion(String parameter, MacroInfo info) throws ParameterException {
        if (parameter != null) {
            try {
                return new CriteriaParser().parse(parameter, this.createCriterionInterpreter(info));
            }
            catch (CriteriaException e) {
                String message = e.getLocalizedMessage();
                throw new ParameterException(StringUtils.isBlank((String)message) ? "Problem occurred while parsing the criteria parameter" : message, e);
            }
        }
        return null;
    }
}

