/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.workflow.rest.model.State;
import com.comalatech.confluence.workflow.rest.model.Trigger;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Workflow {
    @DocumentationExample(value="Example Workflow")
    public String name;
    @DocumentationExample(value="This is an example workflow")
    public String description;
    @DocumentationExample(value="label1", value2="label2")
    public List<String> labels;
    @DocumentationExample(value="false")
    public Boolean invertLabels;
    @DocumentationExample(value="DOCS:Template 1")
    public String pageHeaderTemplate;
    @DocumentationExample(value="DOCS:Template 2")
    public String pageFooterTemplate;
    @DocumentationExample(value="false")
    public Boolean hideStatus;
    @DocumentationExample(value="false")
    public Boolean hideStatusReadOnly;
    @DocumentationExample(value="user1,user2")
    public String adminUsers;
    @DocumentationExample(value="sticky1", value2="sticky2")
    public List<String> stickyLabels;
    @DocumentationExample(value="com.comalatech.example")
    public String key;
    public String blueprintKey;
    public String tip;
    @DocumentationExample(value="false")
    public Boolean updateStatus;
    @DocumentationExample(value="page", value2="news")
    public List<String> contentTypes;
    public Boolean hideStates;
    public Boolean hideTracker;
    @DocumentationExample(value="default")
    public String tasksMode;
    public List<State> states;
    public List<Trigger> triggers;

    public Workflow() {
    }

    public Workflow(com.comalatech.confluence.workflow.Workflow oldWorkflow) {
        this.name = oldWorkflow.getName();
        this.key = oldWorkflow.getKey();
        this.blueprintKey = oldWorkflow.getBlueprintKey();
        this.tip = oldWorkflow.getTip();
        this.description = oldWorkflow.getDescription();
        this.invertLabels = oldWorkflow.isInvertLabels();
        this.pageHeaderTemplate = oldWorkflow.getPageHeaderTemplate();
        this.pageFooterTemplate = oldWorkflow.getPageFooterTemplate();
        this.adminUsers = oldWorkflow.getAdminUserNames();
        this.updateStatus = oldWorkflow.isUpdateStatus();
        this.hideStatus = oldWorkflow.getHideStatus() == 1;
        this.hideStatusReadOnly = oldWorkflow.getHideStatus() == 2;
        this.hideStates = oldWorkflow.isHideStates();
        this.hideTracker = !oldWorkflow.isDisplayProgressTracker();
        switch (oldWorkflow.getTasksMode()) {
            case STRICT: {
                this.tasksMode = "strict";
                break;
            }
            case LENIENT: {
                this.tasksMode = "lenient";
                break;
            }
            default: {
                this.tasksMode = "default";
            }
        }
        this.contentTypes = new ArrayList<String>();
        if (oldWorkflow.isPageWorkflow()) {
            this.contentTypes.add("page");
        }
        if (oldWorkflow.isBlogPostWorkflow()) {
            this.contentTypes.add("news");
        }
        if (!oldWorkflow.getLabels().isEmpty()) {
            this.labels = new ArrayList<String>();
            this.stickyLabels = new ArrayList<String>();
            for (Label label : oldWorkflow.getLabels()) {
                this.labels.add(label.getName());
                if (!oldWorkflow.isLabelSticky(label)) continue;
                this.stickyLabels.add(label.getName());
            }
        }
        this.states = new ArrayList<State>();
        for (com.comalatech.confluence.states.model.State state : oldWorkflow.getStatesContainer().getStates()) {
            this.states.add(new State(state));
        }
        this.triggers = new ArrayList<Trigger>();
        for (com.comalatech.confluence.workflow.model.Trigger trigger : oldWorkflow.getExplicitTriggers()) {
            this.triggers.add(new Trigger(trigger));
        }
    }
}

