/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork;

import com.comalatech.confluence.workflow.mywork.TaskServiceAccessor;
import com.comalatech.confluence.workflow.mywork.TaskServiceFactory;
import com.comalatech.confluence.workflow.mywork.TaskServiceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TaskServiceAccessorImpl
implements TaskServiceAccessor {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceAccessorImpl.class);
    private final ApplicationContext applicationContext;
    private TaskServiceHolder taskServiceHolder;

    public TaskServiceAccessorImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public synchronized TaskServiceHolder getTaskService() {
        if (this.taskServiceHolder == null) {
            this.initNotificationService();
        }
        return this.taskServiceHolder;
    }

    private void initNotificationService() {
        try {
            Class<?> taskServiceFactoryClass = this.getTaskServiceFactoryClass();
            if (taskServiceFactoryClass != null) {
                this.taskServiceHolder = ((TaskServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(taskServiceFactoryClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.debug("Could not create TaskServiceHolder", (Throwable)e);
        }
    }

    private Class<?> getTaskServiceFactoryClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.atlassian.mywork.service.TaskService");
            return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.workflow.mywork.TaskServiceFactory");
        }
        catch (Exception e) {
            log.info("The necessary mywork class is unavailable.");
            return null;
        }
    }
}

