/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.filters;

import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.security.ContentPermission;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.WorkflowPagePermissionSetter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredContentPermissionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DeferredContentPermissionFilter.class);
    private static final String ADD_PERMISSIONS_KEY = "com.comalatech.workflow.permissions.additions";
    private static final String SET_PERMISSIONS_KEY = "com.comalatech.workflow.permissions.sets";
    private WorkflowPagePermissionSetter workflowPagePermissionSetter;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        try {
            ContentPermissionChangesSet changes;
            ContentPermissionChangesSet additions = (ContentPermissionChangesSet)request.getAttribute(ADD_PERMISSIONS_KEY);
            if (additions != null) {
                this.addContentPermissions(additions);
            }
            if ((changes = (ContentPermissionChangesSet)request.getAttribute(SET_PERMISSIONS_KEY)) != null) {
                this.setContentPermissions(changes);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void addContentPermissions(ContentPermissionChangesSet additions) {
        ContentEntityObject ceo = additions.getCeo();
        for (ContentPermission contentPermission : additions) {
            this.workflowPagePermissionSetter.addContentPermission(contentPermission, ceo);
        }
    }

    private void setContentPermissions(ContentPermissionChangesSet changesSet) {
        ContentEntityObject ceo = changesSet.getCeo();
        this.workflowPagePermissionSetter.setContentPermissions(Lists.newArrayList((Iterable)changesSet), ceo);
    }

    public static void addContentPermissionAddition(ContentPermission permission, ContentEntityObject ceo, ServletActionContextCompatManager servletActionContextCompatManager) {
        ContentPermissionChangesSet additions = (ContentPermissionChangesSet)servletActionContextCompatManager.getRequest().getAttribute(ADD_PERMISSIONS_KEY);
        if (additions == null) {
            additions = new ContentPermissionChangesSet(ceo);
            servletActionContextCompatManager.getRequest().setAttribute(ADD_PERMISSIONS_KEY, (Object)additions);
        }
        additions.add(permission);
    }

    public static void addContentPermissionChanges(List<ContentPermission> permissionChanges, ContentEntityObject ceo, ServletActionContextCompatManager servletActionContextCompatManager) {
        ContentPermissionChangesSet existingChanges = (ContentPermissionChangesSet)servletActionContextCompatManager.getRequest().getAttribute(SET_PERMISSIONS_KEY);
        if (existingChanges == null) {
            existingChanges = new ContentPermissionChangesSet(ceo);
            servletActionContextCompatManager.getRequest().setAttribute(SET_PERMISSIONS_KEY, (Object)existingChanges);
        }
        existingChanges.addAll(permissionChanges);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.workflowPagePermissionSetter = PluginContainerManager.getComponent("workflowPagePermissionSetter", WorkflowPagePermissionSetter.class);
    }

    public static class ContentPermissionChangesSet
    extends HashSet<ContentPermission> {
        private ContentEntityObject ceo;

        public ContentPermissionChangesSet(ContentEntityObject ceo) {
            this.ceo = ceo;
        }

        public ContentEntityObject getCeo() {
            return this.ceo;
        }
    }
}

