/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.model;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.TaskAttribute;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class PageTasks {
    private List<PageTask> tasks;
    private List<PageTask> deletedTasks;

    public PageTasks() {
        this.tasks = new ArrayList<PageTask>();
        this.deletedTasks = new ArrayList<PageTask>();
    }

    public PageTasks(List<PageTask> tasks, List<PageTask> deletedTasks) {
        this.tasks = tasks;
        this.deletedTasks = deletedTasks;
    }

    @JsonCreator
    public PageTasks(@JsonProperty(value="deletedTasks") List<PageTask> deletedTasks) {
        this.deletedTasks = deletedTasks;
    }

    @JsonGetter(value="tasks")
    public List<PageTask> getTasks() {
        return this.tasks;
    }

    public List<PageTask> get() {
        return this.tasks;
    }

    public List<PageTask> getActiveTasks() {
        ArrayList<PageTask> activeTasks = new ArrayList<PageTask>();
        for (PageTask task : this.tasks) {
            if (task.isCompleted()) continue;
            activeTasks.add(task);
        }
        return activeTasks;
    }

    public List<PageTask> getCompletedTasks() {
        ArrayList<PageTask> completedTasks = new ArrayList<PageTask>();
        for (PageTask task : this.tasks) {
            if (!task.isCompleted()) continue;
            completedTasks.add(task);
        }
        return completedTasks;
    }

    @JsonGetter(value="deletedTasks")
    public List<PageTask> getDeletedTasks() {
        return this.deletedTasks;
    }

    public void setDeletedTasks(List<PageTask> deletedTasks) {
        this.deletedTasks = deletedTasks;
    }

    public PageTask getById(int taskId) {
        for (PageTask task : this.tasks) {
            if (task.getId() != taskId) continue;
            return task;
        }
        return null;
    }

    public PageTask getByName(String name) {
        for (PageTask task : this.tasks) {
            if (!task.getName().equals(name)) continue;
            return task;
        }
        return null;
    }

    public void add(PageTask task) {
        if (task.getId() == 0) {
            if (this.tasks.size() > 0) {
                task.setId(this.tasks.get(this.tasks.size() - 1).getId() + 1);
            } else {
                task.setId(1);
            }
        }
        this.tasks.add(task);
    }

    public void addDeletedTask(PageTask task) {
        this.deletedTasks.add(task);
    }

    public void addWithoutSettingId(PageTask task) {
        this.tasks.add(task);
    }

    public void update(PageTask task) {
        PageTask pageTask = this.getById(task.getId());
        if (pageTask != null) {
            pageTask.setCompletions(task.getCompletions());
            pageTask.setAssignments(task.getAssignments());
            pageTask.setName(task.getName());
            pageTask.setComment(task.getComment());
            pageTask.setCurrentDueDate(task.getCurrentDueDate());
            pageTask.setDueDateHistory(task.getDueDateHistory());
        }
    }

    public void remove(int taskId) {
        Iterator<PageTask> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getId() != taskId) continue;
            iterator.remove();
            break;
        }
    }

    private Set<TaskAttribute> getActiveAttributes() {
        HashSet<TaskAttribute> set = new HashSet<TaskAttribute>();
        set.add(TaskAttribute.TASK);
        for (PageTask task : this.tasks) {
            Assignment assignment = task.getCurrentAssignment();
            if (assignment == null) continue;
            if (assignment.hasAssignees()) {
                set.add(TaskAttribute.ASSIGNEE);
            }
            if (assignment.getDueDate() == null) continue;
            set.add(TaskAttribute.DUEDATE);
        }
        return set;
    }

    public List<TaskAttributeColumn> getActiveAttributesColumns() {
        Set<TaskAttribute> activeAttributes = this.getActiveAttributes();
        ArrayList<TaskAttributeColumn> columns = new ArrayList<TaskAttributeColumn>();
        for (TaskAttribute taskAttribute : TaskAttribute.values()) {
            if (taskAttribute == TaskAttribute.DUEDATE) continue;
            columns.add(new TaskAttributeColumn(taskAttribute, activeAttributes.contains((Object)taskAttribute)));
        }
        return columns;
    }

    public int size() {
        return this.tasks.size();
    }

    public String getTabTitle() {
        Stats stats = this.getStats();
        StringBuffer title = new StringBuffer(ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.tasks.tasks.name"));
        if (stats.getOpen() > 0) {
            title.append(" (").append(stats.getOpen()).append(")");
        }
        return title.toString();
    }

    public Stats getStats() {
        Stats stats = new Stats();
        for (PageTask task : this.tasks) {
            ++stats.total;
            if (task.isCompleted()) {
                ++stats.completed;
                continue;
            }
            ++stats.open;
        }
        return stats;
    }

    public boolean hasPendingTasks() {
        for (PageTask task : this.tasks) {
            if (task.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted() {
        return this.tasks.stream().allMatch(task -> task.isCompleted());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageTasks pageTasks = (PageTasks)o;
        if (this.tasks != null ? !this.tasks.equals(pageTasks.tasks) : pageTasks.tasks != null) {
            return false;
        }
        return !(this.deletedTasks != null ? !this.deletedTasks.equals(pageTasks.deletedTasks) : pageTasks.deletedTasks != null);
    }

    public void addInvolvedUsers(Set<String> userNames) {
        for (PageTask task : this.tasks) {
            for (Assignment assignment : task.getAssignments()) {
                if (!TextUtils.stringSet((String)assignment.getAssignee())) continue;
                userNames.add(assignment.getAssignee());
            }
        }
    }

    public int hashCode() {
        return this.tasks != null ? this.tasks.hashCode() : 0;
    }

    public String toString() {
        return "Tasks: " + this.tasks.toString() + "    Deleted Tasks: " + this.deletedTasks.toString();
    }

    public class TaskAttributeColumn {
        TaskAttribute attribute;
        boolean enabled;

        @JsonCreator
        public TaskAttributeColumn() {
        }

        public TaskAttributeColumn(TaskAttribute attribute, boolean enabled) {
            this.attribute = attribute;
            this.enabled = enabled;
        }

        public String getKey() {
            return this.attribute.getKey();
        }

        public String getCaption() {
            return this.attribute.getCaption();
        }

        public boolean isMandatory() {
            return this.attribute.isMandatory();
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public class Stats {
        int total = 0;
        int open = 0;
        int completed = 0;

        public int getTotal() {
            return this.total;
        }

        public int getOpen() {
            return this.open;
        }

        public int getCompleted() {
            return this.completed;
        }
    }
}

