/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.states.event.DummyStateSelectEvent;
import com.comalatech.confluence.states.event.StateSelectEvent;
import com.comalatech.confluence.states.model.DueDateWorkflowElement;
import com.comalatech.confluence.states.model.StateColour;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.states.model.StateSubmission;
import com.comalatech.confluence.states.model.Transition;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.workflow.events.AllApproveEvent;
import com.comalatech.confluence.workflow.events.AllRejectEvent;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.model.Workflow;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class State
extends DueDateWorkflowElement
implements Macroable,
Workflow.State {
    private String name;
    private List<State> preceedingStates;
    private List<State> succeedingStates;
    private boolean finalState;
    private boolean versionsCompleted;
    private boolean endState;
    private List<Approval> approvals;
    private List<StateSelection> stateSelections;
    private List<Transition> transitions;
    private List<Task> tasks;
    private ReadAck readAck;
    private boolean assignable;
    private boolean taskable;
    private boolean hasLabelApprovals;
    private boolean hideSelection;
    private boolean hideFromPath;
    private boolean changeDueDate;
    private String colour;
    private String description;
    private String requiredParams;
    private transient String approvedStateName;
    private transient String rejectedStateName;
    private transient String updatedStateName;
    private transient String expiredStateName;
    private transient String completedStateName;
    private static final char[] invalidStateNameCharacters = new char[]{':', ';', '<', '>', '@', '/', '\\', '|', '#', '[', ']', '{', '}', '^', '\"'};

    public State(String name, boolean finalState, String approvedStateName, String rejectedStateName, String updatedStateName, String expiredStateName, String completedStateName) {
        this(name, finalState);
        this.approvedStateName = approvedStateName;
        this.rejectedStateName = rejectedStateName;
        this.updatedStateName = updatedStateName;
        this.expiredStateName = expiredStateName;
        this.completedStateName = completedStateName;
    }

    public State(String name, boolean finalState) {
        super(null);
        this.name = name;
        this.finalState = finalState;
        this.preceedingStates = new ArrayList<State>();
        this.succeedingStates = new ArrayList<State>();
        this.approvals = new ArrayList<Approval>();
        this.stateSelections = new ArrayList<StateSelection>();
        this.transitions = new ArrayList<Transition>();
        this.timers = new ArrayList();
        this.tasks = new ArrayList<Task>();
        this.hasLabelApprovals = false;
    }

    public State(State state) {
        this(state.name, state.finalState);
        this.description = state.description;
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition);
    }

    public List<Transition> getTransitions() {
        return this.transitions;
    }

    public List<StateSelection> getStateSelections() {
        return this.stateSelections;
    }

    public void setAdhocSelections(boolean adhoc) {
        for (StateSelection selection : this.stateSelections) {
            selection.setAdhoc(adhoc);
        }
    }

    @Override
    public boolean isTaskable() {
        return this.taskable;
    }

    public void setTaskable(boolean taskable) {
        this.taskable = taskable;
    }

    public void setStateSelections(List<StateSelection> stateSelections) {
        this.stateSelections = stateSelections;
        if (this.stateSelections.size() > 0) {
            this.addTransition(new Transition(new DummyStateSelectEvent(), null, this, null, true));
        }
    }

    public void setApprovals(List<Approval> approvals) {
        this.approvals = approvals;
        for (Approval approval1 : approvals) {
            Approval approval = approval1;
            if (approval.getLabel() == null) continue;
            this.hasLabelApprovals = true;
            break;
        }
    }

    public List<Approval> getApprovals() {
        return this.approvals;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public Task getTask(String name) {
        for (Task task : this.tasks) {
            if (!task.getName().equals(name)) continue;
            return task;
        }
        return null;
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public List<Approval> getApprovals(AbstractPage page) {
        if (!this.hasLabelApprovals || page == null) {
            return this.approvals;
        }
        ArrayList<Approval> daApprovals = new ArrayList<Approval>(this.approvals);
        List pageLabels = page.getLabels();
        Iterator iterator = daApprovals.iterator();
        while (iterator.hasNext()) {
            Approval approval = (Approval)iterator.next();
            Label label = approval.getLabel();
            if (label == null || pageLabels.contains(label)) continue;
            iterator.remove();
        }
        return daApprovals;
    }

    public void addPreceedingState(State state) {
        this.preceedingStates.add(state);
    }

    public void addSucceedingState(State state) {
        this.succeedingStates.add(state);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEndState() {
        return this.endState;
    }

    public void setEndState(boolean endState) {
        this.endState = endState;
    }

    public void setVersionsCompleted(boolean versionsCompleted) {
        this.versionsCompleted = versionsCompleted;
    }

    @Override
    public boolean isAssignable() {
        return this.assignable;
    }

    public void setAssignable(boolean assignable) {
        this.assignable = assignable;
    }

    public boolean isHasLabelApprovals() {
        return this.hasLabelApprovals;
    }

    public void setHasLabelApprovals(boolean hasLabelApprovals) {
        this.hasLabelApprovals = hasLabelApprovals;
    }

    public void setFinalState(boolean finalState) {
        this.finalState = finalState;
    }

    public String getRequiredParams() {
        return this.requiredParams;
    }

    public void setRequiredParams(String requiredParams) {
        this.requiredParams = requiredParams;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<State> getPreceedingStates() {
        return this.preceedingStates;
    }

    public List<State> getSucceedingStates() {
        return this.succeedingStates;
    }

    public Set<State> getForwardStates() {
        HashSet<State> forwardStates = new HashSet<State>();
        for (Transition transition : this.transitions) {
            if (!transition.isForward()) continue;
            if (transition.getEvent() instanceof StateSelectEvent) {
                this.appendStatesFromSelections(forwardStates);
                continue;
            }
            if (transition.getNextState() == null) continue;
            forwardStates.add(transition.getNextState());
        }
        return forwardStates;
    }

    public Set<State> getBackwardStates() {
        HashSet<State> backwardStates = new HashSet<State>();
        for (Transition transition : this.transitions) {
            if (transition.isForward()) continue;
            if (transition.getEvent() instanceof StateSelectEvent) {
                this.appendStatesFromSelections(backwardStates);
                continue;
            }
            if (transition.getNextState() == null) continue;
            backwardStates.add(transition.getNextState());
        }
        return backwardStates;
    }

    private void appendStatesFromSelections(Set<State> states) {
        for (StateSelection selection : this.stateSelections) {
            for (State allowedState : selection.getAllowedStates()) {
                states.add(allowedState);
            }
        }
    }

    public State getApprovedState() {
        for (Transition transition : this.transitions) {
            if (transition.getNextState() == null || !(transition.getEvent() instanceof AllApproveEvent)) continue;
            return transition.getNextState();
        }
        return null;
    }

    public State getRejectedState() {
        for (Transition transition : this.transitions) {
            if (transition.getNextState() == null || !(transition.getEvent() instanceof AllRejectEvent)) continue;
            return transition.getNextState();
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isFinalState() {
        return this.finalState;
    }

    @Override
    public boolean isVersionsCompleted() {
        return this.versionsCompleted;
    }

    public String getApprovedStateName() {
        return this.approvedStateName;
    }

    public void setApprovedStateName(String approvedStateName) {
        this.approvedStateName = approvedStateName;
    }

    public String getRejectedStateName() {
        return this.rejectedStateName;
    }

    public void setRejectedStateName(String rejectedStateName) {
        this.rejectedStateName = rejectedStateName;
    }

    public String getUpdatedStateName() {
        return this.updatedStateName;
    }

    public void setUpdatedStateName(String updatedStateName) {
        this.updatedStateName = updatedStateName;
    }

    public ReadAck getReadAck() {
        return this.readAck;
    }

    public void setReadAck(ReadAck readAck) {
        this.readAck = readAck;
    }

    public void renameReferredStateName(String oldName, String newName) {
        if (oldName.equals(this.approvedStateName)) {
            this.approvedStateName = newName;
        }
        if (oldName.equals(this.rejectedStateName)) {
            this.rejectedStateName = newName;
        }
        if (oldName.equals(this.updatedStateName)) {
            this.updatedStateName = newName;
        }
        if (oldName.equals(this.expiredStateName)) {
            this.expiredStateName = newName;
        }
        if (oldName.equals(this.completedStateName)) {
            this.completedStateName = newName;
        }
    }

    public void removeStateReference(State removedState) {
        State state;
        Iterator<StateSelection> selectionIterator = this.getStateSelections().iterator();
        while (selectionIterator.hasNext()) {
            StateSelection selection = selectionIterator.next();
            selection.removeAllowedState(removedState);
            if (selection.getAllowedStates().size() != 0) continue;
            selectionIterator.remove();
        }
        Iterator<Transition> transitionIterator = this.getTransitions().iterator();
        while (transitionIterator.hasNext()) {
            Transition transition = transitionIterator.next();
            if (!removedState.equals(transition.getNextState()) && !removedState.equals(transition.getSourceState())) continue;
            transitionIterator.remove();
        }
        if (removedState.getName().equals(this.approvedStateName)) {
            this.approvedStateName = null;
        }
        if (removedState.getName().equals(this.rejectedStateName)) {
            this.rejectedStateName = null;
        }
        if (removedState.getName().equals(this.updatedStateName)) {
            this.updatedStateName = null;
        }
        if (removedState.getName().equals(this.expiredStateName)) {
            this.updatedStateName = null;
        }
        if (removedState.getName().equals(this.completedStateName)) {
            this.completedStateName = null;
        }
        Iterator<State> stateIterator = this.preceedingStates.iterator();
        while (stateIterator.hasNext()) {
            state = stateIterator.next();
            if (!state.equals(removedState)) continue;
            stateIterator.remove();
        }
        stateIterator = this.succeedingStates.iterator();
        while (stateIterator.hasNext()) {
            state = stateIterator.next();
            if (!state.equals(removedState)) continue;
            stateIterator.remove();
        }
    }

    public static boolean isValidStateName(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() > 255) {
            return false;
        }
        if (name.startsWith("~") || name.startsWith("$") || name.startsWith("..") || name.startsWith("'")) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (State.isValidStateNameCharacter(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidStateNameCharacter(char c) {
        for (char invalidTitleCharacter : invalidStateNameCharacters) {
            if (c != invalidTitleCharacter) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String name) {
        return this.name != null && this.name.equals(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return !(this.name != null ? !this.name.equals(state.name) : state.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("hideSelection", this.hideSelection).append("preceedingStates", (Object[])this.statesNames(this.preceedingStates)).append("succeedingStates", (Object[])this.statesNames(this.succeedingStates)).append("approvals", this.approvals).toString();
    }

    private String[] statesNames(List<State> list) {
        String[] names = new String[list.size()];
        int i = 0;
        for (State state : list) {
            names[i++] = state.getName();
        }
        return names;
    }

    public State getSubmitState() {
        for (StateSelection stateSelection : this.stateSelections) {
            if (!(stateSelection instanceof StateSubmission)) continue;
            return ((StateSubmission)stateSelection).getNextState();
        }
        return null;
    }

    @Override
    public SerializableMacro toMacro() {
        return this.toMacro(false);
    }

    @Override
    public SerializableMacro toMacro(boolean workflowHasFinalState) {
        String dueDate;
        SerializableMacro macro = new SerializableMacro("state", true);
        macro.addParameter(this.name);
        if (this.finalState) {
            macro.addParameter("final", (Object)this.finalState);
        }
        if (this.versionsCompleted) {
            macro.addParameter("versionscompleted", (Object)this.versionsCompleted);
        }
        if (this.getSubmitState() != null) {
            macro.addParameter("submit", (Object)this.getSubmitState().getName());
        }
        macro.addParameter("approved", (Object)this.approvedStateName);
        macro.addParameter("rejected", (Object)this.rejectedStateName);
        macro.addParameter("updated", (Object)this.updatedStateName);
        macro.addParameter("expired", (Object)this.expiredStateName);
        macro.addParameter("completed", (Object)this.completedStateName);
        macro.addParameter("description", (Object)this.description);
        for (StateSelection selection : this.stateSelections) {
            if (!selection.isExplicit()) continue;
            macro.addMacro(selection.toMacro());
        }
        if (this.assignable) {
            macro.addParameter("assignable", (Object)this.assignable);
        }
        if (this.taskable) {
            macro.addParameter("taskable", (Object)this.taskable);
        }
        if (this.hideSelection) {
            macro.addParameter("hideselection", (Object)this.hideSelection);
        }
        if (this.hideFromPath) {
            macro.addParameter("hidefrompath", (Object)this.hideFromPath);
        }
        if ((dueDate = this.getDueDate()) != null) {
            macro.addParameter("duedate", (Object)dueDate);
        }
        if (this.changeDueDate) {
            macro.addParameter("changeduedate", (Object)this.changeDueDate);
        }
        for (Approval approval : this.approvals) {
            macro.addMacro(approval.toMacro());
        }
        for (Task task : this.tasks) {
            macro.addMacro(task.toMacro());
        }
        if (this.readAck != null) {
            macro.addMacro(this.readAck.toMacro());
        }
        if (!StateColour.isDefaultStateColour(this.colour, this.finalState, workflowHasFinalState)) {
            macro.addParameter("colour", (Object)this.colour);
        }
        macro.addParameter("requiredparams", (Object)this.requiredParams);
        return macro;
    }

    public String getExpiredStateName() {
        return this.expiredStateName;
    }

    public void setExpiredStateName(String expiredStateName) {
        this.expiredStateName = expiredStateName;
    }

    public String getCompletedStateName() {
        return this.completedStateName;
    }

    public void setCompletedStateName(String completedStateName) {
        this.completedStateName = completedStateName;
    }

    public boolean isHideSelection() {
        if (TextUtils.stringSet((String)this.rejectedStateName) || TextUtils.stringSet((String)this.approvedStateName) || TextUtils.stringSet((String)this.expiredStateName) || TextUtils.stringSet((String)this.updatedStateName) || TextUtils.stringSet((String)this.completedStateName)) {
            return true;
        }
        return this.hideSelection;
    }

    public boolean isHideSelectionProperty() {
        return this.hideSelection;
    }

    public void setHideSelection(boolean hideSelection) {
        this.hideSelection = hideSelection;
    }

    public boolean isHideFromPath() {
        return this.hideFromPath;
    }

    public void setHideFromPath(boolean hideFromPath) {
        this.hideFromPath = hideFromPath;
    }

    public boolean isChangeDueDate() {
        return this.changeDueDate;
    }

    public void setChangeDueDate(boolean changeDueDate) {
        this.changeDueDate = changeDueDate;
    }

    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }
}

