/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.supplier;

import com.comalatech.confluence.ipc.supplier.SupplierAssistantAccessor;
import com.comalatech.confluence.ipc.supplier.SupplierAssistantFactory;
import com.comalatech.confluence.ipc.supplier.SupplierAssistantHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SupplierAssistantAccessorImpl
implements SupplierAssistantAccessor {
    private static final Logger log = LoggerFactory.getLogger(SupplierAssistantAccessorImpl.class);
    private final ApplicationContext applicationContext;
    private SupplierAssistantHolder supplierAssistantHolder;

    public SupplierAssistantAccessorImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public synchronized SupplierAssistantHolder getSupplierAssistant() {
        if (this.supplierAssistantHolder == null) {
            this.initSupplierAssistant();
        }
        return this.supplierAssistantHolder;
    }

    private void initSupplierAssistant() {
        try {
            Class<?> supplierAssistantFactoryClass = this.getSupplierAssistantFactoryClass();
            if (supplierAssistantFactoryClass != null) {
                this.supplierAssistantHolder = ((SupplierAssistantFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(supplierAssistantFactoryClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.debug("Could not create SupplierAssistantHolder", (Throwable)e);
        }
    }

    private Class<?> getSupplierAssistantFactoryClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.servicerocket.confluence.randombits.supplier.core.SupplierAssistant");
            return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.ipc.supplier.SupplierAssistantFactory");
        }
        catch (Exception e) {
            log.info("The necessary supplier class is unavailable.");
            return null;
        }
    }
}

