/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.approval;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.events.BlogPostApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.PageApprovalRejectEvent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.model.SignatureType;

public class ApprovalRejectedMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public ApprovalRejectedMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        BlogPostApprovalRejectEvent blogPostApprovalRejectEvent;
        if (event instanceof PageApprovalRejectEvent) {
            PageApprovalRejectEvent pageApprovalRejectEvent = (PageApprovalRejectEvent)event;
            if (pageApprovalRejectEvent.isPartial()) {
                return this.buildActivity(pageApprovalRejectEvent.getAbstractPage(), pageApprovalRejectEvent.getState(), pageApprovalRejectEvent.getApprovalCheck(), pageApprovalRejectEvent.getApprovalCheck().getLastApprover());
            }
        } else if (event instanceof BlogPostApprovalRejectEvent && (blogPostApprovalRejectEvent = (BlogPostApprovalRejectEvent)event).isPartial()) {
            return this.buildActivity(blogPostApprovalRejectEvent.getAbstractPage(), blogPostApprovalRejectEvent.getState(), blogPostApprovalRejectEvent.getApprovalCheck(), blogPostApprovalRejectEvent.getApprovalCheck().getLastApprover());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, ApprovalCheck approvalCheck, Approver approver) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(approver.getUserName());
        ActionDetails details = this.buildApprovalsActionDetails(approvalCheck.getName(), approvalCheck.getId(), approver.getComment());
        if (approver != null && approver.getSignatureType() != SignatureType.NONE) {
            details.addDetail(ActionDetail.Type.APPROVAL_SIGNATURE_MODE, approver.getESignature().toString());
            details.addDetail(ActionDetail.Type.APPROVAL_SIGNATURE_TYPE, approver.getSignatureType().toString());
        }
        details.addAll(this.buildRoleNameActionDetails(approver.getRole()));
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.APPROVAL, ActionType.Subtype.APPROVAL_REJECTED), actor, details);
        return new Activity(ApprovalRejectedMapper.buildTarget((ContentEntityObject)abstractPage), approver.getDate().getTime(), action);
    }
}

