/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action.condition;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.action.condition.AbstractPageWorkflowCondition;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import java.util.Map;

public class CanUserAddWorkflowToPage
extends AbstractPageWorkflowCondition {
    private final AccessModeService accessModeService;
    private final PermissionManager permissionManager;
    private final SpacePermissionManager spacePermissionManager;

    public CanUserAddWorkflowToPage(WorkflowContainerManager workflowContainerManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowPermissionManager workflowPermissionManager, AccessModeService accessModeService, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager) {
        super(workflowContainerManager, adhocWorkflowManager, workflowConfigurationManager, workflowPermissionManager);
        this.accessModeService = accessModeService;
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    private boolean canEdit(ConfluenceUser user, AbstractPage page) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        AbstractPage page = this.getPage(context);
        Space space = page.getSpace();
        if (space != null) {
            return this.canEdit(user, page) || this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user) || this.permissionManager.isConfluenceAdministrator((User)user);
        }
        return false;
    }
}

