/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.intercom;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.randombits.confluence.intercom.Connection;
import org.randombits.confluence.intercom.ConnectionBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConnectionBundle
implements ConnectionBundle {
    private Set<Connection> connections;

    public LocalConnectionBundle(Connection ... connections) {
        this(Arrays.asList(connections));
    }

    public LocalConnectionBundle(Collection<Connection> connections) {
        HashSet<Connection> copy = new HashSet<Connection>();
        copy.addAll(connections);
        this.connections = Collections.unmodifiableSet(copy);
    }

    @Override
    public Connection[] getConnections() {
        return this.connections.toArray(new Connection[this.connections.size()]);
    }

    @Override
    public <C extends Connection> C[] getConnections(Class<C> connectionType) {
        if (connectionType != null) {
            HashSet<Connection> filtered = new HashSet<Connection>();
            for (Connection c : this.connections) {
                if (!connectionType.isInstance(c)) continue;
                filtered.add(c);
            }
            Connection[] conns = (Connection[])Array.newInstance(connectionType, filtered.size());
            return filtered.toArray(conns);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + this.connections + " ]";
    }
}

