/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflow.macros.templates.NoBodyBaseMacro;
import com.comalatech.confluence.workflow.restv2.model.report.RestSpaceReportFilterWorkflow;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ColumnsParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.DefaultValuesParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.FieldListParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParentPageParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.SpaceParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.StringListParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.UsernameParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.ColumnsParameterValidator;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.ItemsPerPageParameterValidator;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.ParameterValidator;
import com.comalatech.confluence.workflowreports.model.WorkflowStatesReportFilters;
import com.comalatech.confluence.workflowreports.model.WorkflowStatesReportOptions;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowStateReportFiltersJsonPresenter;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowStateReportOptionsCqlPresenter;
import com.comalatech.workflow.model.Workflow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Qualifier;

public class WorkflowStateReportMacro
extends NoBodyBaseMacro
implements Macro {
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowsFeatureManager workflowsFeatureManager;
    private ApprovalsSearchService approvalsSearchService;
    private WorkflowService workflowService;
    private PageManager pageManager;
    private UserAccessor userAccessor;
    protected Parameters options;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final String STATES_TEMPLATE = "/templates/reports/macros/states-report-macro.vm";

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        this.options = new Parameters(parameters, renderContext);
        WorkflowStatesReportOptions statesReportOptions = this.options.getWorkflowStatesReportOptions();
        WorkflowStatesReportFilters statesReportFilters = this.buildReportFilters();
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.putAll(new WorkflowStateReportOptionsCqlPresenter(statesReportOptions, this.objectMapper).present());
        contextMap.putAll(new WorkflowStateReportFiltersJsonPresenter(statesReportFilters, this.objectMapper).present());
        contextMap.put("currentSpaceKey", this.getCurrentSpaceKey(renderContext));
        contextMap.put("workflowLicenseMessageHtml", this.getWorkflowLicenseMessageHtml());
        return this.renderTemplate(contextMap, STATES_TEMPLATE);
    }

    private WorkflowStatesReportFilters buildReportFilters() {
        List<String> states = this.getReportStateFilter();
        List<RestSpaceReportFilterWorkflow> workflows = this.getReportWorkflowFilter();
        return new WorkflowStatesReportFilters(states, workflows);
    }

    protected List<String> getReportStateFilter() {
        ArrayList<String> spaceStates = new ArrayList<String>();
        if (this.options.getWorkflowStatesReportOptions().isSingleSpace()) {
            spaceStates.addAll(this.approvalsSearchService.getSpaceStates(this.options.getWorkflowStatesReportOptions().getFirstSpaceKey()));
        }
        return spaceStates;
    }

    protected List<RestSpaceReportFilterWorkflow> getReportWorkflowFilter() {
        ArrayList<RestSpaceReportFilterWorkflow> restWorkflows = new ArrayList<RestSpaceReportFilterWorkflow>();
        if (this.workflowsFeatureManager.isWorkflowsApp() || this.workflowsFeatureManager.isWorkflowsLiteApp()) {
            ArrayList<Workflow> workflows = new ArrayList<Workflow>();
            if (this.options.getWorkflowStatesReportOptions().isSingleSpace()) {
                workflows.addAll(this.workflowService.getWorkflows(this.options.getWorkflowStatesReportOptions().getFirstSpaceKey()));
            }
            for (Workflow workflow : workflows) {
                if (!workflow.isActive()) continue;
                RestSpaceReportFilterWorkflow restWorkflow = new RestSpaceReportFilterWorkflow();
                restWorkflow.name = workflow.getName();
                restWorkflow.states = workflow.getStateNames();
                restWorkflows.add(restWorkflow);
            }
        }
        return restWorkflows;
    }

    public String getCurrentSpaceKey(RenderContext renderContext) throws MacroException {
        if (renderContext instanceof PageContext && this.getAbstractPage(renderContext) != null) {
            return this.getAbstractPage(renderContext).getSpaceKey();
        }
        return null;
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        try {
            return this.execute(parameters, (RenderContext)conversionContext.getPageContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setApprovalsSearchService(ApprovalsSearchService approvalsSearchService) {
        this.approvalsSearchService = approvalsSearchService;
    }

    protected class Parameters
    extends MacroParameters {
        private final WorkflowStatesReportOptions options;

        public Parameters(Map parameters, RenderContext renderContext) throws MacroException {
            super(parameters, renderContext);
            AbstractPage page = null;
            if (renderContext instanceof PageContext && this.getAbstractPage() != null) {
                page = this.getAbstractPage().getLatestVersion();
            }
            List<ReportParameter> reportParameters = StateReportParameters.getFiltersFrom(parameters.entrySet());
            this.applyParameterMappers(reportParameters, page);
            this.applyParametersValidators(reportParameters);
            this.options = new WorkflowStatesReportOptions(reportParameters);
        }

        private void applyParametersValidators(List<ReportParameter> reportParameters) throws MacroException {
            ArrayList<ParameterValidator> validators = new ArrayList<ParameterValidator>();
            validators.add(new ItemsPerPageParameterValidator(1, WorkflowStateReportMacro.this.workflowsFeatureManager.getPluginKey()));
            validators.add(new ColumnsParameterValidator(WorkflowStateReportMacro.this.workflowsFeatureManager.getPluginKey()));
            for (ReportParameter parameter : reportParameters) {
                for (ParameterValidator validator : validators) {
                    validator.validate(parameter);
                }
            }
        }

        private void applyParameterMappers(List<ReportParameter> reportParameters, AbstractPage page) {
            ArrayList<ParameterMapper> mappers = new ArrayList<ParameterMapper>();
            mappers.add(new DefaultValuesParameterMapper());
            mappers.add(new SpaceParameterMapper(page));
            mappers.add(new ColumnsParameterMapper());
            mappers.add(new ParentPageParameterMapper(WorkflowStateReportMacro.this.pageManager, page));
            mappers.add(new FieldListParameterMapper());
            mappers.add(new StringListParameterMapper());
            mappers.add(new UsernameParameterMapper(WorkflowStateReportMacro.this.userAccessor));
            for (ReportParameter param : reportParameters) {
                mappers.forEach(mapper -> mapper.map(param));
            }
        }

        public WorkflowStatesReportOptions getWorkflowStatesReportOptions() {
            return this.options;
        }
    }
}

