/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.mappers;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.PluginLicenseStatus;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.dao.sax.PageStateConverter;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.dao.sax.ApprovalChecksConverter;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.DebugData;
import com.opensymphony.util.TextUtils;
import java.util.List;

public class DebugDataPopulator
implements SupportConsoleReportDataPopulator<DebugData, AbstractPage> {
    private final WorkflowAccessor workflowAccessor;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final PluginAccessor pluginAccessor;
    private final AdhocWorkflowsLicenseManager licenseManager;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final String newLine;

    public DebugDataPopulator(WorkflowAccessor workflowAccessor, WorkflowsFeatureManager workflowsFeatureManager, PluginAccessor pluginAccessor, AdhocWorkflowsLicenseManager adhocWorkflowsLicenseManager, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor) {
        this.workflowAccessor = workflowAccessor;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.pluginAccessor = pluginAccessor;
        this.licenseManager = adhocWorkflowsLicenseManager;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
        this.newLine = System.getProperty("line.separator");
    }

    @Override
    public DebugData populateForTarget(AbstractPage target) {
        return DebugData.builder().latestState(PageStateConverter.convertToXml(this.stateAccessor.getLatestState(target))).statesXml(PageStateConverter.convertToXml(this.stateAccessor.getPageStates(target))).approvalChecksXml(ApprovalChecksConverter.convertToXml(this.approvalAccessor.getApprovalChecks(target))).finalApprovalCheck(this.approvalAccessor.getFinalApprovalCheckId(target) + "").latestApprovalCheck(ApprovalChecksConverter.convertToXml(this.approvalAccessor.getLatestApprovalCheck(target))).activeWorkflowInformation(this.getActiveWorkflowsInformation(target)).pluginInfo(this.getPluginInfo()).build();
    }

    private String getActiveWorkflowsInformation(AbstractPage page) {
        String appName;
        StringBuilder debugsString = new StringBuilder();
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        String string = appName = this.workflowsFeatureManager.isWorkflowsApp() ? "Workflow" : "Approval";
        if (pageWorkflows != null) {
            List<Workflow> workflows = pageWorkflows.getWorkflows();
            debugsString.append("\n\nActive ").append(appName).append("s\n");
            for (Workflow workflow : workflows) {
                debugsString.append(workflow.getName()).append(" |  Labels: ").append(workflow.getLabelNames()).append(" invertLabels: ").append(workflow.isInvertLabels()).append(this.newLine);
            }
            debugsString.append(this.newLine).append(this.newLine).append(appName).append(" Markup\n");
            for (Workflow workflow : workflows) {
                debugsString.append(workflow.getName()).append(this.newLine);
                debugsString.append(workflow.getWorkflowMarkup()).append(this.newLine).append(this.newLine);
            }
        } else {
            debugsString.append(this.newLine).append(this.newLine).append("No Active").append(appName).append("s").append(this.newLine);
        }
        return debugsString.toString();
    }

    private String getPluginInfo() {
        StringBuilder debugsString = new StringBuilder();
        debugsString.append("Plugin and License info\n");
        Plugin plugin = this.pluginAccessor.getEnabledPlugin(this.workflowsFeatureManager.getPluginKey());
        debugsString.append(plugin.getName()).append(" ").append(plugin.getPluginInformation().getVersion()).append(this.newLine);
        PluginLicenseStatus status = this.licenseManager.getLicenseStatus();
        if (TextUtils.stringSet((String)status.getMessageHtml())) {
            debugsString.append(status.getMessageHtml()).append(this.newLine);
        }
        if (TextUtils.stringSet((String)status.getStatus().name())) {
            debugsString.append(status.getStatus().name()).append(this.newLine);
        }
        return debugsString.toString();
    }
}

