/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.resources;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.rest.model.RestWorkflowParam;
import com.comalatech.confluence.workflow.rest.model.RestWorkflowParamTranslator;
import com.comalatech.confluence.workflow.rest.resources.AbstractAdminRestResource;
import com.comalatech.workflow.model.WorkflowParameter;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import com.opensymphony.util.TextUtils;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@WorkflowsAppRequired
@Path(value="/workflows")
@Produces(value={"application/json"})
public class WorkflowSpaceAdminResource
extends AbstractAdminRestResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowSpaceAdminResource.class);
    private final InternalWorkflowParameterManager workflowParameterManager;
    private final WorkflowService workflowService;

    public WorkflowSpaceAdminResource(WorkflowService workflowService, PermissionManager permissionManager, SpaceManager spaceManager, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, AdhocWorkflowDao adhocWorkflowDao, WorkflowsFeatureManager workflowsFeatureManager, PageManager pageManager, InternalWorkflowParameterManager workflowParameterManager) {
        super(permissionManager, spaceManager, workflowTemplateManager, adhocWorkflowDao, workflowsFeatureManager, pageManager);
        this.workflowParameterManager = workflowParameterManager;
        this.workflowService = workflowService;
    }

    @GET
    @Path(value="/{spaceKey}")
    @PermissionRequired(value={"ADMINISTER"})
    public Response getSpaceWorkflows(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> spaceWorkflows = WorkflowSpaceAdminResource.this.workflowService.getWorkflows(spaceKey);
                return Response.ok().entity(WorkflowSpaceAdminResource.this.buildRestWorkflowList(spaceWorkflows)).build();
            }
        }.execute();
    }

    @GET
    @Path(value="/{spaceKey}/{workflowId}")
    @PermissionRequired(value={"ADMINISTER"})
    public Response getWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    com.comalatech.workflow.model.Workflow workflow = WorkflowSpaceAdminResource.this.workflowService.getWorkflow(spaceKey, workflowId);
                    if (workflow != null) {
                        WorkflowSpaceAdminResource.this.moveReadAckMacroOutsideState(workflow);
                        return Response.ok().entity((Object)WorkflowSpaceAdminResource.this.buildRestWorkflow(workflow)).build();
                    }
                    return Response.noContent().build();
                }
                catch (WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }

    @GET
    @Path(value="/{spaceKey}/available")
    @PermissionRequired(value={"ADMINISTER"})
    public Response getAvailableWorkflows(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> spaceWorkflows = WorkflowSpaceAdminResource.this.workflowService.getAvailableWorkflowsTemplates(spaceKey);
                return Response.ok().entity(WorkflowSpaceAdminResource.this.buildRestWorkflowList(spaceWorkflows)).build();
            }
        }.execute();
    }

    @GET
    @Path(value="/{spaceKey}/pagetemplates")
    @PermissionRequired(value={"ADMINISTER"})
    public Response getPageTemplates(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> pageWorkflows = WorkflowSpaceAdminResource.this.workflowService.getPageWorkflowTemplates(spaceKey);
                return Response.ok().entity(WorkflowSpaceAdminResource.this.buildRestWorkflowList(pageWorkflows)).build();
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/activate")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/xml", "application/json"})
    public Response activateWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId, @QueryParam(value="label") String label) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    WorkflowSpaceAdminResource.this.workflowService.activateWorkflow(spaceKey, workflowId);
                }
                catch (WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
                return WorkflowSpaceAdminResource.this.getSpaceWorkflows(spaceKey);
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/deactivate")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/xml", "application/json"})
    public Response deactivateWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                WorkflowSpaceAdminResource.this.workflowService.deactivateWorkflow(spaceKey, workflowId);
                return WorkflowSpaceAdminResource.this.getSpaceWorkflows(spaceKey);
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/hide")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/xml", "application/json"})
    public Response hideWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                WorkflowSpaceAdminResource.this.workflowService.hideWorkflowTemplate(spaceKey, workflowId);
                return WorkflowSpaceAdminResource.this.getPageTemplates(spaceKey);
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/show")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/xml", "application/json"})
    public Response showWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                WorkflowSpaceAdminResource.this.workflowService.showWorkflowTemplate(spaceKey, workflowId);
                return WorkflowSpaceAdminResource.this.getPageTemplates(spaceKey);
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/{workflowId}/copy")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/xml", "application/json"})
    public Response copyWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId, final @QueryParam(value="active") boolean active) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    WorkflowSpaceAdminResource.this.workflowService.copyWorkflowToSpace(spaceKey, workflowId, active);
                    return WorkflowSpaceAdminResource.this.getSpaceWorkflows(spaceKey);
                }
                catch (com.comalatech.workflow.WorkflowException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }

    @PUT
    @Path(value="/{spaceKey}/{workflowId}")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/xml", "application/json"})
    public Response updateWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId, final Map<String, Object> updateJson) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    String handle = workflowId;
                    String name = (String)updateJson.get("name");
                    String label = (String)updateJson.get("label");
                    String description = (String)updateJson.get("description");
                    String markup = (String)updateJson.get("markup");
                    com.comalatech.workflow.model.Workflow workflow = WorkflowSpaceAdminResource.this.workflowService.updateWorkflow(spaceKey, handle, name, description, label, markup, false);
                    Workflow.WorkflowType workflowType = ((Workflow)workflow).getType();
                    if (Workflow.WorkflowType.SPACE_TEMPLATE == workflowType) {
                        return WorkflowSpaceAdminResource.this.getPageTemplates(spaceKey);
                    }
                    return WorkflowSpaceAdminResource.this.getSpaceWorkflows(spaceKey);
                }
                catch (com.comalatech.workflow.WorkflowException e) {
                    String errorAsJson = WorkflowSpaceAdminResource.this.convertXHtmlToJson(StringEscapeUtils.escapeHtml4((String)e.getMessage()));
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorAsJson).build();
                }
                catch (ClassCastException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/")
    @PermissionRequired(value={"ADMINISTER"})
    public Response addSpaceWorkflow(final @PathParam(value="spaceKey") String spaceKey, final Map<String, Object> updateJson) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    String markup = (String)updateJson.get("markup");
                    if (TextUtils.stringSet((String)markup)) {
                        try {
                            WorkflowSpaceAdminResource.this.workflowService.addSpaceWorkflow(spaceKey, markup);
                        }
                        catch (com.comalatech.workflow.WorkflowException e) {
                            return WorkflowSpaceAdminResource.this.handleException(e);
                        }
                    }
                    return WorkflowSpaceAdminResource.this.getSpaceWorkflows(spaceKey);
                }
                catch (ClassCastException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/pagetemplate")
    @PermissionRequired(value={"ADMINISTER"})
    public Response addPageTemplateMarkup(final @PathParam(value="spaceKey") String spaceKey, final Map<String, Object> updateJson) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    String markup = (String)updateJson.get("markup");
                    if (TextUtils.stringSet((String)markup)) {
                        try {
                            WorkflowSpaceAdminResource.this.workflowTemplateManager.addWorkflowTemplate(WorkflowSpaceAdminResource.this.spaceManager.getSpace(spaceKey), markup);
                        }
                        catch (com.comalatech.workflow.WorkflowException e) {
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                        }
                    }
                    return WorkflowSpaceAdminResource.this.getPageTemplates(spaceKey);
                }
                catch (ClassCastException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }

    @DELETE
    @Path(value="/{spaceKey}/{workflowId}")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/xml", "application/json"})
    public Response deleteWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                com.comalatech.workflow.model.Workflow workflow = WorkflowSpaceAdminResource.this.workflowService.deleteWorkflow(spaceKey, workflowId);
                Workflow.WorkflowType workflowType = ((Workflow)workflow).getType();
                if (Workflow.WorkflowType.SPACE_TEMPLATE == workflowType) {
                    return WorkflowSpaceAdminResource.this.getPageTemplates(spaceKey);
                }
                return WorkflowSpaceAdminResource.this.getSpaceWorkflows(spaceKey);
            }
        }.execute();
    }

    @GET
    @Path(value="/{spaceKey}/workflowParameter")
    @PermissionRequired(value={"ADMINISTER"})
    public Response getWorkflowParameters(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<WorkflowParameter> workflowParameters = WorkflowSpaceAdminResource.this.workflowParameterManager.getSpaceWorkflowsParameters(spaceKey);
                return Response.ok(RestWorkflowParamTranslator.toRest(workflowParameters)).build();
            }
        }.execute();
    }

    @POST
    @Path(value="/{spaceKey}/workflowParameter")
    @PermissionRequired(value={"ADMINISTER"})
    public Response setWorkflowParameter(final @PathParam(value="spaceKey") String spaceKey, final RestWorkflowParam restWorkflowParam) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                WorkflowSpaceAdminResource.this.workflowParameterManager.registerWorkflowParameter(spaceKey, RestWorkflowParamTranslator.toModel(restWorkflowParam));
                return Response.ok((Object)restWorkflowParam).build();
            }
        }.execute();
    }

    @PUT
    @Path(value="/{spaceKey}/workflowParameter/{paramId}")
    @PermissionRequired(value={"ADMINISTER"})
    public Response updateWorkflowParameter(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="paramId") String paramId, final RestWorkflowParam restWorkflowParam) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                String name = new String(Base64.getDecoder().decode(paramId.getBytes()));
                if (name.equals(restWorkflowParam.getName())) {
                    try {
                        WorkflowSpaceAdminResource.this.workflowParameterManager.setSpaceWorkflowParameter(spaceKey, RestWorkflowParamTranslator.toModel(restWorkflowParam));
                        return Response.ok((Object)restWorkflowParam).build();
                    }
                    catch (com.comalatech.workflow.WorkflowException ex) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)ex.getMessage())).build();
                    }
                }
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)restWorkflowParam).build();
            }
        }.execute();
    }

    @DELETE
    @Path(value="/{spaceKey}/workflowParameter/{paramId}")
    @PermissionRequired(value={"ADMINISTER"})
    public Response deleteWorkflowParameter(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="paramId") String paramId) {
        return new AbstractAdminRestResource.RestCommand(spaceKey){

            @Override
            public Response doExecute() {
                String name = new String(Base64.getDecoder().decode(paramId.getBytes()));
                for (WorkflowParameter workflowParameter : WorkflowSpaceAdminResource.this.workflowParameterManager.getSpaceWorkflowsParameters(spaceKey)) {
                    if (!name.equals(workflowParameter.getName())) continue;
                    WorkflowSpaceAdminResource.this.workflowParameterManager.unRegisterWorkflowParameter(spaceKey, workflowParameter);
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }.execute();
    }
}

