/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions.metadata;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.ipc.ValueAccessor;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import com.comalatech.confluence.workflow.macros.actions.metadata.MetadataUtils;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementMetadataMacro
extends AbstractActionMacro {
    private static final Logger log = LoggerFactory.getLogger(IncrementMetadataMacro.class);
    protected static final String INCREMENT_PARAM = "increment";
    private ValueAccessor workflowValueAccessor;
    private InternalWorkflowParameterManager workflowParameterManager;

    @Override
    protected String getName() {
        return "increment-metadata";
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        boolean isValidRenderPage;
        String name = MapUtils.getString(parameters, "0");
        String increment = MapUtils.getString(parameters, INCREMENT_PARAM);
        if (!TextUtils.stringSet((String)name)) {
            throw new MacroException("value name not defined");
        }
        if (TextUtils.stringSet((String)increment) && !MetadataUtils.hasDigit(increment)) {
            throw new MacroException("increment value does not contain any number");
        }
        ValueStore renderContextValueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
        AbstractPage renderPage = this.getAbstractPage(renderContext);
        boolean bl = isValidRenderPage = renderPage.getSpaceKey() != null && renderPage.getId() != 0L;
        if (this.inExecuteMode(renderContext) || isValidRenderPage) {
            List<AbstractPage> pages = this.getPagesFromParams(parameters, renderContext);
            for (AbstractPage page : pages) {
                String value = this.workflowParameterManager.getRenderedParameter(page, name, renderContext);
                if (!TextUtils.stringSet((String)value)) {
                    log.info("metadata name not defined or empty for this page:" + name);
                    return "";
                }
                String newVersion = MetadataUtils.incrementMetadataVersion(increment, value);
                ValueStore valueStore = renderContextValueStore != null && renderContextValueStore.getEvent() != null ? this.valueStoreManager.createValueStore(page, renderContextValueStore.getEvent(), renderContextValueStore.getPropertiesMap()) : (renderContextValueStore != null ? this.valueStoreManager.createValueStore(page, renderContextValueStore.getPropertiesMap()) : this.valueStoreManager.createValueStore(page));
                this.workflowValueAccessor.setValue(valueStore.getPage(), name, valueStore.replaceReferences(newVersion));
            }
        }
        return "";
    }

    public void setWorkflowValueAccessor(ValueAccessor workflowValueAccessor) {
        this.workflowValueAccessor = workflowValueAccessor;
    }

    public void setWorkflowParameterManager(InternalWorkflowParameterManager workflowParameterManager) {
        this.workflowParameterManager = workflowParameterManager;
    }
}

