/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflow.esignatures.model.SigningTokenRegistry;
import com.comalatech.confluence.workflow.esignatures.model.TokenExpiryDateUpdateRequest;
import com.comalatech.confluence.workflow.esignatures.resources.AbstractRestESignaturesResource;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.esignatures.service.TOTPHelper;
import com.comalatech.confluence.workflow.esignatures.validator.ESignatureValidator;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.model.RestESignatures;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@WorkflowsAppRequired
@WorkflowsLiteAppRequired
@Path(value="/admin/esignatures")
@Produces(value={"application/json"})
public class ESignaturesResource
extends AbstractRestESignaturesResource {
    private final ESignaturesConfigurationManager eSignaturesConfigurationManager;
    private final ESignaturesService eSignaturesService;
    private final ESignatureValidator validator;

    public ESignaturesResource(ESignaturesConfigurationManager eSignaturesConfigurationManager, WorkflowsFeatureManager workflowsFeatureManager, PermissionManager permissionManager, ESignaturesService eSignaturesService, UserAccessor userAccessor) {
        super(permissionManager, workflowsFeatureManager);
        this.eSignaturesConfigurationManager = eSignaturesConfigurationManager;
        this.eSignaturesService = eSignaturesService;
        TOTPHelper totpHelper = new TOTPHelper();
        this.validator = new ESignatureValidator(totpHelper, userAccessor);
    }

    @GET
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/json"})
    public Response getCredentials() {
        return new AbstractRestESignaturesResource.RestCommand(){

            @Override
            public Response doExecute() {
                return ESignaturesResource.this.getESignatureCredentialsResponse();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveCredentials(final ESignatureCredentials credentials) {
        return new AbstractRestESignaturesResource.RestCommand(){

            @Override
            public Response doExecute() {
                if (credentials == null || credentials.getCredentials() == null) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                ESignaturesResource.this.eSignaturesConfigurationManager.setESignaturesCredentials(credentials.getCredentials().getValue());
                return ESignaturesResource.this.getESignatureCredentialsResponse();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @DELETE
    @PermissionRequired(value={"ADMINISTER"})
    @Path(value="/{userKey}")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="User ESingnature data is deleted"), @ResponseCode(code=403, condition="User is not administrator"), @ResponseCode(code=404, condition="Cannot find credentials type after deleting the user data"), @ResponseCode(code=400, condition="Blank or empty user key")})
    public Response deleteSigningToken(final @PathParam(value="userKey") String userKey) {
        if (!this.validator.isUserValid(userKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.validator.getJSONError()).build();
        }
        return new AbstractRestESignaturesResource.RestCommand(){

            @Override
            public Response doExecute() {
                ESignaturesResource.this.eSignaturesService.purgeSigningToken(userKey);
                return ESignaturesResource.this.getESignatureCredentialsResponse();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @PUT
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="User ESingnature data is deleted"), @ResponseCode(code=403, condition="User is not administrator"), @ResponseCode(code=404, condition="Cannot find credentials type after deleting the user data")})
    public Response updateTokenExpiryTimeStamp(final TokenExpiryDateUpdateRequest tokenExpiryDateUpdateRequest) {
        if (this.validator.isInvalidValidUpdateRequest(tokenExpiryDateUpdateRequest)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.validator.getJSONError()).build();
        }
        return new AbstractRestESignaturesResource.RestCommand(){

            @Override
            public Response doExecute() {
                SigningTokenRegistry registry = new SigningTokenRegistry();
                registry.setUserKey(tokenExpiryDateUpdateRequest.getUserKey());
                registry.setExpiryTimestamp(tokenExpiryDateUpdateRequest.getExpiryDate());
                ESignaturesResource.this.eSignaturesService.updateSigningTokeRecord(registry);
                return ESignaturesResource.this.getESignatureCredentialsResponse();
            }
        }.execute();
    }

    private Response getESignatureCredentialsResponse() {
        String credentials = this.eSignaturesConfigurationManager.getESignaturesCredentials();
        if (credentials != null) {
            return this.buildRestESignatures(credentials);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected Response buildRestESignatures(String credentials) {
        RestESignatures restESignatures = new RestESignatures(credentials);
        restESignatures.setUserEsignatureData(this.eSignaturesService.getUserESignatureData());
        return Response.ok().entity((Object)restESignatures).type("application/json").build();
    }
}

