/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompatManager;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.actions.ViewPageCookieUtils;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ViewPageAction
extends com.atlassian.confluence.pages.actions.ViewPageAction
implements PageAware {
    private static final Logger log = LoggerFactory.getLogger(ViewPageAction.class);
    private static final String VIEW_RELEASED_RESULT = "viewreleased";
    private static final String[] EXCLUDED_PARAMS = new String[]{"pageId", "spaceKey", "title"};
    private ApprovalAccessor approvalAccessor;
    private WorkflowAccessor workflowAccessor;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private WebResourceManager webResourceManager;
    private WorkflowPermissionManager workflowPermissionManager;
    private StateService stateService;
    private ActionContextCompatManager actionContextCompatManager;
    private ServletActionContextCompatManager servletActionContextCompatManager;
    private Integer approvalId;
    private ApprovalCheck approvalCheck;
    private boolean subjectToWorkflow = false;
    private boolean draft;
    public static final String NO_DRAFT_VIEW_PERMITTED_ERROR_I18N = "approvalsworkflow.approval.page.not.permitted";
    private ReportDateFormatter dateFormatter;

    private ApprovalCheck getApprovalCheck() {
        if (this.approvalId == null) {
            Integer finalApprovalId = this.approvalAccessor.getFinalApprovalCheckId(this.getPage());
            if (finalApprovalId == null || finalApprovalId == 0) {
                return null;
            }
            this.approvalId = finalApprovalId;
        }
        this.approvalCheck = this.approvalAccessor.getApprovalCheck(this.getPage().getLatestVersion(), this.approvalId);
        if (this.approvalCheck == null) {
            log.error("invalid approvalId " + this.approvalId);
            return null;
        }
        return this.approvalCheck;
    }

    public String getActionParameters() {
        return this.getActionParameters("&");
    }

    public ReportDateFormatter getReportDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new ReportDateFormatter(this.getLocaleManager());
        }
        return this.dateFormatter;
    }

    public String getActionParameters(String firstSeparator) {
        Map<?, ?> actionParams = this.actionContextCompatManager.getParameters();
        StringBuffer sb = new StringBuffer();
        String separator = firstSeparator;
        for (Object name : actionParams.keySet()) {
            String[] values;
            if (Arrays.binarySearch(EXCLUDED_PARAMS, name) >= 0) continue;
            for (String value : values = (String[])actionParams.get(name)) {
                sb.append(separator).append(name).append('=').append(HtmlUtil.urlEncode((String)value));
                separator = "&";
            }
        }
        return sb.toString();
    }

    public String getReleasedViewUrl() {
        AbstractPage page = this.getPage();
        String path = ViewPageAction.makePrettyReleasedUrlPath(page);
        return path + this.getActionParameters(path.indexOf("?") >= 0 ? "&" : "?");
    }

    public static String makePrettyReleasedUrlPath(AbstractPage page) {
        String path = page.getUrlPath();
        path = !(page instanceof BlogPost) && path.startsWith("/display/") ? path.replaceAll("/display/", "/display/public/") : "/pages/releaseview.action?pageId=" + page.getIdAsString();
        return path;
    }

    public boolean isPermitted() {
        if (!super.isPermitted()) {
            return false;
        }
        AbstractPage page = this.getPage();
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page.getLatestVersion());
        if (pageWorkflows == null) {
            return true;
        }
        this.subjectToWorkflow = true;
        if (this.approvalId == null) {
            boolean isPermitted;
            boolean viewDraftByDefault = this.workflowConfigurationManager.isViewDraftByDefault(page.getSpace());
            boolean canViewDraft = this.isPermitted(page);
            if (viewDraftByDefault && canViewDraft) {
                return true;
            }
            if (this.getApprovalCheck() != null && this.approvalCheck.isApproved()) {
                return true;
            }
            boolean bl = isPermitted = canViewDraft || !pageWorkflows.isRequiresFinalApproval();
            if (!isPermitted) {
                try {
                    page = (AbstractPage)page.clone();
                }
                catch (Exception e) {
                    log.error("could not clone page " + page.getDisplayTitle(), (Throwable)e);
                }
                String msg = this.getText(NO_DRAFT_VIEW_PERMITTED_ERROR_I18N);
                page.setBodyAsString(ViewPageAction.renderErrorBody(msg));
                this.setPage(page);
                isPermitted = true;
            }
            return isPermitted;
        }
        if (this.getApprovalCheck() == null) {
            return this.isPermitted(page);
        }
        return this.approvalCheck.isApproved() || this.isPermitted(page);
    }

    public static String renderErrorBody(String msg) {
        return "<div id=\"workflow_page_not_permitted\" class=\"aui-message error shadowed\">    <p class=\"title\">        <span class=\"aui-icon icon-error\">        </span>        <strong>" + msg + "        </strong>    </p></div>";
    }

    private boolean isPermitted(AbstractPage page) {
        ConfluenceUser user = this.getAuthenticatedUser();
        return this.workflowPermissionManager.canViewDrafts(page, user);
    }

    public boolean isViewDraft() {
        return this.draft || ViewPageCookieUtils.isViewDraft(this.getPage(), this.servletActionContextCompatManager) || this.workflowConfigurationManager.isViewDraftByDefault(this.getSpace());
    }

    public String execute() throws Exception {
        if (this.subjectToWorkflow) {
            this.webResourceManager.requireResource("confluence.web.resources:jquery");
            this.webResourceManager.requireResource("confluence.web.resources:ajs");
            this.webResourceManager.requireResource("com.comalatech.workflow:workflowResources");
            if (this.isViewDraft() && this.isPermitted(this.getPage())) {
                ViewPageCookieUtils.setViewDraft(this.getPage(), this.servletActionContextCompatManager);
            } else {
                State publishedState = this.stateService.getPublishedState((ContentEntityObject)this.getPage());
                if (log.isDebugEnabled()) {
                    log.debug("user: " + this.getAuthenticatedUser() + " does not have permission to see draft page: " + this.getPage() + "   final approval is: " + this.approvalCheck + "  published state is: " + publishedState);
                }
                if (publishedState != null) {
                    return VIEW_RELEASED_RESULT;
                }
                ViewPageCookieUtils.setViewPublished(this.getPage(), this.servletActionContextCompatManager);
            }
        }
        return super.execute();
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setApprovalAccessor(ApprovalAccessor approvalAccessor) {
        this.approvalAccessor = approvalAccessor;
    }

    public void setWorkflowAccessor(WorkflowAccessor workflowAccessor) {
        this.workflowAccessor = workflowAccessor;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setWorkflowPermissionManager(WorkflowPermissionManager workflowPermissionManager) {
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }

    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = DefaultWebInterfaceContext.copyOf((WebInterfaceContext)super.getWebInterfaceContext());
        if (((Object)((Object)this)).getClass().equals(ViewPageAction.class)) {
            result.setParameter("viewMode", (Object)Boolean.TRUE);
        }
        return result;
    }

    public void setActionContextCompatManager(@Qualifier(value="actionContextCompatManager") ActionContextCompatManager actionContextCompatManager) {
        this.actionContextCompatManager = actionContextCompatManager;
    }

    public void setServletActionContextCompatManager(@Qualifier(value="servletActionContextCompat") ServletActionContextCompatManager servletActionContextCompatManager) {
        this.servletActionContextCompatManager = servletActionContextCompatManager;
    }
}

