/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.license;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.keys.UpgradePropertiesKeys;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class WorkflowsFeatureManagerImpl
implements WorkflowsFeatureManager {
    private static final List<String> PLUGIN_KEYS = Arrays.asList("com.comalatech.workflow", "com.comalatech.cloud.approvals", "com.comalatech.workflow.approvals");
    private static final Map<String, String> PLUGIN_KEY_TO_PREFIX_HASH = ImmutableMap.of((Object)"com.comalatech.workflow", (Object)"workflows", (Object)"com.comalatech.cloud.approvals", (Object)"workflows-lite", (Object)"com.comalatech.workflow.approvals", (Object)"approvals");
    private static final Map<String, String> PLUGIN_KEY_TO_APP_NAME_HASH = ImmutableMap.of((Object)"com.comalatech.workflow", (Object)"Comala Document Management", (Object)"com.comalatech.cloud.approvals", (Object)"Comala Document Control", (Object)"com.comalatech.workflow.approvals", (Object)"Comala Document Approval");
    private static final Map<String, String> PLUGIN_KEY_TO_LOGO_NAME_HASH = ImmutableMap.of((Object)"com.comalatech.workflow", (Object)"adhocworkflows-logo", (Object)"com.comalatech.cloud.approvals", (Object)"workflows_lite_logo", (Object)"com.comalatech.workflow.approvals", (Object)"approvals_logo");
    private final String pluginKey;
    private List<String> pageWorkflowPropertyKeys = new ArrayList<String>();
    private List<String> spaceWorkflowPrefixes = new ArrayList<String>();
    private final BandanaManager bandanaManager;
    private Boolean isNewInstallation = null;

    public WorkflowsFeatureManagerImpl(PluginLicenseManager licenseManager, BandanaManager bandanaManager) {
        this.pluginKey = licenseManager.getPluginKey();
        this.bandanaManager = bandanaManager;
        if (this.isWorkflowsApp()) {
            this.spaceWorkflowPrefixes.add("com.comalatech.workflow.production.");
            this.spaceWorkflowPrefixes.add("com.comalatech.workflow.lite.prod.");
            this.pageWorkflowPropertyKeys.add("com.comalatech.workflow.adhoc.");
            this.pageWorkflowPropertyKeys.add("com.comalatech.workflow.lite.");
        } else if (this.isWorkflowsLiteApp()) {
            this.spaceWorkflowPrefixes.add("com.comalatech.workflow.lite.prod.");
            this.pageWorkflowPropertyKeys.add("com.comalatech.workflow.lite.");
        }
        this.spaceWorkflowPrefixes.add("com.comalatech.approval.production.");
        this.pageWorkflowPropertyKeys.add("com.comalatech.workflow.approval.");
    }

    @Override
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Override
    public boolean isApprovalsApp() {
        return "com.comalatech.workflow.approvals".equals(this.getPluginKey());
    }

    @Override
    public boolean isWorkflowsApp() {
        return "com.comalatech.workflow".equals(this.getPluginKey());
    }

    @Override
    public boolean isWorkflowsLiteApp() {
        return "com.comalatech.cloud.approvals".equals(this.getPluginKey());
    }

    @Override
    public String getPageWorkflowPropertyKey() {
        if (this.isWorkflowsApp()) {
            return "com.comalatech.workflow.adhoc.";
        }
        if (this.isWorkflowsLiteApp()) {
            return "com.comalatech.workflow.lite.";
        }
        if (this.isApprovalsApp()) {
            return "com.comalatech.workflow.approval.";
        }
        return null;
    }

    @Override
    public List<String> getPageWorkflowPropertyKeys() {
        return this.pageWorkflowPropertyKeys;
    }

    @Override
    public List<String> getSpaceWorkflowPropertyKeys() {
        return this.spaceWorkflowPrefixes;
    }

    @Override
    public String getSpaceWorkflowPropertyKey() {
        if (this.isWorkflowsApp()) {
            return "com.comalatech.workflow.production.";
        }
        if (this.isWorkflowsLiteApp()) {
            return "com.comalatech.workflow.lite.prod.";
        }
        if (this.isApprovalsApp()) {
            return "com.comalatech.approval.production.";
        }
        return null;
    }

    @Override
    public boolean isNewInstallation() {
        if (this.isNewInstallation == null) {
            this.isNewInstallation = Boolean.valueOf((String)this.bandanaManager.getValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, this.pluginKey + (Object)((Object)UpgradePropertiesKeys.KEY_SEPARATOR) + (Object)((Object)UpgradePropertiesKeys.NEW_INSTALL_KEY)));
        }
        return this.isNewInstallation;
    }

    @Override
    public String getAppLogoName(String key) {
        if (key == null) {
            key = this.getPluginKey();
        }
        return PLUGIN_KEY_TO_LOGO_NAME_HASH.get(key);
    }

    @Override
    public String getAppPrefix(String key) {
        if (key == null) {
            key = this.getPluginKey();
        }
        return PLUGIN_KEY_TO_PREFIX_HASH.get(key);
    }

    @Override
    public String getAppName(String key) {
        if (key == null) {
            key = this.getPluginKey();
        }
        return PLUGIN_KEY_TO_APP_NAME_HASH.get(key);
    }

    public static boolean isWorkflowsUser(String name) {
        return PLUGIN_KEYS.contains(name);
    }
}

