/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.usecases;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.upgrade.support.commands.Diff;
import com.comalatech.confluence.documentActivity.upgrade.support.commands.DocActivityCSV;
import com.comalatech.confluence.documentActivity.upgrade.support.commands.PageActivityCSV;
import com.comalatech.confluence.documentActivity.upgrade.support.model.DiffData;
import com.comalatech.confluence.documentActivity.upgrade.support.model.DocActivityCSVData;
import com.comalatech.confluence.documentActivity.upgrade.support.model.PageActivityCSVData;
import com.comalatech.confluence.documentActivity.upgrade.utils.CSVComparator;
import com.comalatech.confluence.documentActivity.upgrade.utils.SupportPackageFile;
import com.comalatech.confluence.documentActivity.usecases.contracts.ValidateDocumentActivity;
import com.comalatech.confluence.workflow.supportconsole.commands.Debug;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.contract.SupportData;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ValidateDocumentActivityUseCase
implements ValidateDocumentActivity {
    private static final Logger log = LoggerFactory.getLogger(ValidateDocumentActivityUseCase.class);
    private final ActivityManager activityManager;
    private final PageActivityCsvService pageActivityCsvService;
    private final PageActivityCsvService docActivityCsvService;
    private final SupportConsoleReportDataPopulator<SupportData, AbstractPage> debugDataPopulator;
    private final DocActivityCSV docActivityCSV;
    private final PageActivityCSV pageActivityCSV;
    private final Diff diff;
    private final Debug debug;

    public ValidateDocumentActivityUseCase(ActivityManager activityManager, @Qualifier(value="pageActivityCsvService") PageActivityCsvService pageActivityCsvService, @Qualifier(value="docActivityCsvService") PageActivityCsvService docActivityCsvService, @Qualifier(value="debugDataPopulator") SupportConsoleReportDataPopulator debugDataPopulator, SupportPresenter templateFileLayoutHelper) {
        this.activityManager = activityManager;
        this.pageActivityCsvService = pageActivityCsvService;
        this.docActivityCsvService = docActivityCsvService;
        this.debugDataPopulator = debugDataPopulator;
        this.docActivityCSV = new DocActivityCSV(templateFileLayoutHelper);
        this.pageActivityCSV = new PageActivityCSV(templateFileLayoutHelper);
        this.diff = new Diff(templateFileLayoutHelper);
        this.debug = new Debug(templateFileLayoutHelper);
    }

    @Override
    public boolean validate(AbstractPage content, List<Activity> activityList, boolean isDebugEnabled, Path baseFolder) throws Exception {
        if (content == null) {
            log.error("Can not validate document activity entries of a non existing page");
            return false;
        }
        ActivityReportOptions exportOptions = new ActivityReportOptions(false, true, true, false, false, false, Integer.MAX_VALUE);
        List<ActivityReportEntry> activityReportEntries = this.activityManager.getActivityReport(content, exportOptions);
        String newCSVEntries = this.docActivityCsvService.getPageActivityFileContent(activityList, content, PageActivityCsvConfig.builder().skipOtherVersion(true).locale(Locale.UK).build());
        String oldCSVEntries = this.pageActivityCsvService.getPageActivityFileContent(activityReportEntries, content, PageActivityCsvConfig.builder().skipOtherVersion(true).locale(Locale.UK).build());
        String difference = CSVComparator.compare(oldCSVEntries, newCSVEntries);
        if (!"".equals(difference) && isDebugEnabled) {
            this.generateLogFiles(content, baseFolder, newCSVEntries, oldCSVEntries, difference);
            return false;
        }
        return "".equals(difference);
    }

    private void generateLogFiles(AbstractPage content, Path baseFolder, String newCSV, String oldCSV, String difference) throws Exception {
        SupportPackageFile.generateFolder(baseFolder);
        this.docActivityCSV.generateSupportFile(DocActivityCSVData.builder().csv(newCSV).build(), baseFolder);
        this.pageActivityCSV.generateSupportFile(PageActivityCSVData.builder().csv(oldCSV).build(), baseFolder);
        this.diff.generateSupportFile(DiffData.builder().content(difference).build(), baseFolder);
        this.debug.generateSupportFile(this.debugDataPopulator.populateForTarget(content), baseFolder);
    }
}

