/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder;

import com.comalatech.confluence.documentActivity.ao.accesor.builder.FilterBuilder;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class StateFilterBuilder
implements FilterBuilder {
    @Override
    public Query build(DocumentActivityQuery query) {
        List<String> states;
        DocumentActivityQueryFilter filters = query.getFilters();
        if (filters != null && (states = filters.getStateNames()) != null && !states.isEmpty()) {
            String placeHolder = states.stream().map(s -> "?").collect(Collectors.joining(","));
            String clause = "STATE_NAME IN (" + placeHolder + ")";
            ArrayList<String> values = new ArrayList<String>(states);
            return Query.select().where(clause, values.toArray());
        }
        return null;
    }

    @Override
    public boolean shouldApply(DocumentActivityQuery query) {
        DocumentActivityQueryFilter filters = query.getFilters();
        if (filters != null) {
            List<String> states = filters.getStateNames();
            return states != null && !states.isEmpty();
        }
        return false;
    }
}

