/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.approvals.rest.resources;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.approvals.utils.ApprovalUtils;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import com.opensymphony.util.TextUtils;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/page")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PermissionRequired(value={"EDIT"})
public class ApprovalPageResource
extends AbstractRestResource {
    private static final Logger log = LoggerFactory.getLogger(ApprovalPageResource.class);
    private final AdhocWorkflowManager adhocWorkflowManager;

    public ApprovalPageResource(PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager);
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    @POST
    @Path(value="/{contentId}/approval")
    public Response createPageApproval(@PathParam(value="contentId") Long contentId) {
        return this.savePageApproval(contentId, true);
    }

    private Response savePageApproval(final Long contentId, final boolean setInitialialState) {
        return new AbstractRestResource.RestPageCommand(contentId){

            @Override
            public Response doExecute() {
                AbstractPage page = ApprovalPageResource.this.pageManager.getAbstractPage(contentId.longValue());
                if (page == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                Workflow workflow = null;
                try {
                    workflow = ApprovalPageResource.this.adhocWorkflowManager.parseWorkflowMarkup(ApprovalUtils.SIMPLE_APPROVAL_WORKFLOW);
                    if (TextUtils.stringSet((String)workflow.getErrorMessage())) {
                        log.error("comalatech.awp.designer.error.markup" + workflow.getErrorMessage());
                        return Response.serverError().build();
                    }
                    Workflow updatedWorkflow = ApprovalPageResource.this.adhocWorkflowManager.savePageWorkflow(page, workflow, setInitialialState);
                    return Response.ok((Object)Mappers.workflowMapper.toRest(updatedWorkflow)).build();
                }
                catch (WorkflowException ex) {
                    log.error("Error creating/updating page approval", (Throwable)ex);
                    return Response.serverError().build();
                }
                catch (MapperException mEx) {
                    log.error("Mapper error trying to restify a approval", (Throwable)mEx);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }
}

