/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
AWP.View = AWP.View || {};


AWP.View.ParamsTab = Backbone.View.extend({
    // backbone prop
    id: "params",
    className : "tabs-pane awp-container awp-parameters",
    // custom prop
    caption : AJS.I18n.getText("adhocworkflows.tab.params"),
    icon: "params",
    template: AWP.Templates.parameters,
    editing: false,
    
    events: {
        'click .editparams' : 'edit',
        'click .saveparams' : 'save',
        'click .cancelparams' : 'cancel'
    },
    
    initialize: function(params, startEditing) {
        this.model = new AWP.Model.Parameters({
            fields: params
        });
        
        // Start param tab with edit mode
        this.editing = startEditing;
    },
    
    cancel: function (evt) {
        evt.preventDefault();
        if(this.editing) {
            this.editing = false;
            this.view();
        }
        else {
            AWP.View.WorkflowApp.closeDialog();
        }
    },
    
    edit: function (evt) {
        if(evt) {
            evt.preventDefault();
        }
        this.reset();
        _.each(this.model.get('fields'), this.editParam, this);
        this.$editBtn.hide();
        this.$saveBtn.show();
        this.setupAutocompleteFields();
        this.editing = true;
    },
    
    view: function () {
        this.reset();
        _.each(this.model.get('fields'), this.viewParam, this);
        this.$editBtn.show();
        this.$saveBtn.hide();
    },

    viewParam: function (param) {
        this.$body.append(AWP.Templates.viewParameter({
            param: param
        }));
    },
    
    editParam: function (param) {
        var autocomplete = false;
        if(param.type) {
            // We omit case sensitivity
            // type=USER|user|User etc. will enable autocomplete
            autocomplete = (param.type.toLowerCase() === "user");
        }
        this.$body.append(AWP.Templates.editParameter({
            param: param,
            userAutocomplete: autocomplete
        }));
        this.setupAutocompleteFields();
    },

    setupAutocompleteFields: function () {
        this.$('.awp-autocomplete-filtered-user:not(.awp-autocomplete-bound)').each(function() {
            var users = "",
                groups = "",
                self = this;

            var view = new AWP.View.AutocompleteUser({
                el: AJS.$(this),
                filterUsers: users,
                filterGroups: groups
            });
            view.render();
            view.on("select.autocomplete-user", function(user) {
                AJS.$(self).attr('value', user.get('username'));
            });

            AJS.$(this).addClass('awp-autocomplete-bound');
        });
    },
    
    render: function() {
        this.$el.append(this.template({}));
        this.$body = this.$('fieldset');
        this.$editBtn = this.$('.editparams');
        this.$saveBtn = this.$('.saveparams');

        if(this.editing) {
            this.edit();
        }
        else {
            this.view();
        }
        return this;
    },

    reset: function () {
        this.$body.html('');
    },
    
    save: function (evt) {
        var formFields = [];

        evt.preventDefault();
        
        this.$('.text').each(function(i, field) {
            formFields.push({
                id: field.name,
                value: field.value
            });
        });

        this.$('.select').each(function(i, field) {
            formFields.push({
                id: field.name,
                value: AJS.$("option:selected",AJS.$(this)).text()
            });
        });
        
        this.model.save({
            fields: formFields
        });
    }
});