/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * @since 4.0
 */
var AWP = AWP || {};
(function ($, AJS) {
    AWP.debug = false;      // true ONLY FOR DEVEL!
    AWP.VERSION = '1.3.0';    // Adhoc Workflow Plugin New UI version

    /**
     * Method for logging at development state
     * AWP.debug = false will deactive logging
     */
    AWP.log = function (s) {
        if(AWP.debug) {
            AJS.log('[AWP] ' + s);
        }
    };

	AJS.toInit(function () {
        // Confluence 5.5-m7 compatibility
        // missing AJS.debug when we use it for the user-suggestion list
        if(typeof AJS.debug === 'undefined') {
            AWP.log('AJS.debug not detected. Fixing it...');
            AJS.debug = function (s) {
                AJS.log(s);
            };
        }

        AWP.workflow = new AWP.Model.Workflow();
        AWP.workflow.fetch({
            workflow: true,
            success: function() {
                AWP.workflowApp = new AWP.View.WorkflowApp({
                    el: "body",
                    model: AWP.workflow
                });
                AJS.Meta.set("context-path", AWP.contextPath); // needed by quicksetdropdown.js
            },
            error: function(model, response) {
                // We render the dialog as usual
                AWP.workflowApp = new AWP.View.WorkflowApp({
                    el: "body",
                    model: AWP.workflow
                });
                AJS.Meta.set("context-path", AWP.contextPath); // needed by quicksetdropdown.js

            }
        });
    });

	AWP.log("AWP Version: " + AWP.VERSION);
})(AJS.$, AJS);
