/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
AWP.Embedded = AWP.Embedded || {};

/**
 * Singleton to deal with the remote <-> Local communication
 * @type {*}
 */
AWP.Embedded.Events = new function($) {

    /**
     * Refreshes the inpage state and other related web elements
     */
    this.refreshState =  function(event, pageStatus) {
        AWP.Embedded.Workflow.setState(pageStatus);
    };

    this.refreshMsg =  function(event, messages) {
        AWP.Embedded.Workflow.setMessages(messages);
    };

    this.closeWorkflowDialog =  function() {
        AWP.Embedded.Workflow.hideDialog();
        AWP.Embedded.Workflow.hideModalDialog();
    };

    /**
     * Enables the Add Workflow dialog
     * @param event
     * @return {Boolean}
     */
    this.addWorkflow = function(event) {
        event.preventDefault();
        var workflow = AWP.Embedded.Workflow;

        workflow.showModalDlg();
        var $content = $("#" + workflow.getModalDialogId());
        $content.html("").append(AWP.Templates.iframeSmall({
                    pageId: AJS.params.pageId,
                    contextPath: AJS.Confluence.getContextPath()
                }));
        return false;
    };

    /**
     * Enables the workflow dialog, but open on the tasks tab, when the user selects the 'Add Tasks menu item
     * @param event
     */
    this.addTask = function(event) {
        event.preventDefault();
        var workflow = AWP.Embedded.Workflow;
        // invokes the popup dialog defined on workflow.js.
        workflow.setAction('addtask');
        $("#" + workflow.getDialogId()).click();
        //$("#adhocWorkflowsPopupLink").addClass("add-task").click();
    };

    /**
     * Enables the workflow dialog, but to add the default approval workflow, when the user selects the 'Add approval
     * menu item.
     * @param event
     */
    this.addApprovalWorkflow = function(event) {
        event.preventDefault();
        // invokes the popup dialog defined on workflow.js.
        AWP.Embedded.Workflow.setAction('addapproval');
        $("#" + AWP.Embedded.Workflow.getDialogId()).click();
    };

    // because of the version of javascript we have, this is the way to go...
    $(document).delegate("iframe.adhoworkflows","awp.refresh",this.refreshState);
    $(document).delegate("iframe.adhoworkflows","awp.refreshMsg",this.refreshMsg);
    $(document).delegate("iframe.adhoworkflows","awp.close",this.closeWorkflowDialog);
    $(document).delegate("#addApprovalWorkflow","click",this.addApprovalWorkflow);
}(AJS.$);
