/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.servlet;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.StorageException;
import org.randombits.storage.StringBasedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameterStorage
extends StringBasedStorage {
    private HttpServletRequest req;

    public RequestParameterStorage(HttpServletRequest req) {
        super(BasedStorage.BoxType.Virtual);
        this.req = req;
    }

    @Override
    protected Set<String> baseNameSet() {
        return null;
    }

    @Override
    protected String getBaseString(String name) {
        return this.req.getParameter(name);
    }

    @Override
    protected void setBaseString(String name, String value) {
        throw new UnsupportedOperationException("Values cannot be set for RequestParameterStorage objects.");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected String[] getBaseStringArray(String name) throws StorageException {
        return this.req.getParameterValues(name);
    }

    @Override
    protected void setBaseStringArray(String name, String[] value) {
        throw new UnsupportedOperationException("RequestParameterStorage is read-only.");
    }
}

