/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.intercom.thing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.randombits.confluence.intercom.ConnectionBundle;
import org.randombits.confluence.intercom.LocalIntercom4;
import org.randombits.confluence.intercom.LocalIntercomListener;
import org.randombits.confluence.intercom.thing.ThingConnection;
import org.randombits.confluence.intercom.thing.ThingListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThingFinder<T, C extends ThingConnection<T>>
implements LocalIntercomListener {
    private static final Logger LOG = Logger.getLogger(ThingFinder.class);
    private Class<C> connectionType;
    private Set<T> mThings;
    private Set<T> uThings;
    private Class<T> thingType;
    private List<ThingListener<T>> listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThingFinder(Class<T> thingType, Class<C> connectionType) {
        LocalIntercom4 intercom;
        if (ThingConnection.class.equals(connectionType)) {
            throw new IllegalArgumentException("Connection types must be a subclass of ThingConnection, not ThingConnection itself.");
        }
        this.mThings = new HashSet<T>();
        this.uThings = Collections.unmodifiableSet(this.mThings);
        this.connectionType = connectionType;
        this.thingType = thingType;
        LocalIntercom4 localIntercom4 = intercom = LocalIntercom4.getInstance();
        synchronized (localIntercom4) {
            this.addThings(intercom.findConnections(connectionType));
            intercom.addLocalIntercomListener(this);
        }
    }

    private void addThings(Collection<C> connections) {
        if (connections != null) {
            for (ThingConnection p : connections) {
                this.addThing(p);
            }
        } else {
            this.warnAboutNullThings();
        }
    }

    private void warnAboutNullThings() {
        LOG.warn((Object)"Null connections passed into ThingFinder.");
    }

    private void addThings(C[] connections) {
        if (connections != null) {
            for (C p : connections) {
                this.addThing((ThingConnection<T>)p);
            }
        } else {
            this.warnAboutNullThings();
        }
    }

    private void addThing(ThingConnection<T> p) {
        T value = p.getThing();
        if (this.mThings.add(value) && this.listeners != null) {
            for (ThingListener<T> listener : this.listeners) {
                listener.thingProvided(value);
            }
        }
    }

    public Set<T> getThings() {
        return this.uThings;
    }

    public Class<T> getThingType() {
        return this.thingType;
    }

    @Override
    public synchronized void addedConnectionBundle(ConnectionBundle bundle) {
        this.addThings((ThingConnection[])bundle.getConnections(this.connectionType));
    }

    @Override
    public synchronized void removedConnectionBundle(ConnectionBundle bundle) {
        this.removeThings((ThingConnection[])bundle.getConnections(this.connectionType));
    }

    private void removeThings(C[] connections) {
        if (connections != null) {
            for (C p : connections) {
                Object value = p.getThing();
                if (!this.mThings.remove(value) || this.listeners == null) continue;
                for (ThingListener listener : this.listeners) {
                    listener.thingRemoved(value);
                }
            }
        } else {
            this.warnAboutNullThings();
        }
    }
}

