/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.manager.stats;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflowreports.manager.stats.DocumentStatsReportManager;
import com.comalatech.confluence.workflowreports.model.presenter.stats.DocumentStatsReportOptionsCqlPresenter;
import com.comalatech.confluence.workflowreports.model.stats.DocumentStatsReport;
import com.comalatech.confluence.workflowreports.model.stats.DocumentStatsReportOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultDocumentStatsReportManager
implements DocumentStatsReportManager {
    private final CQLSearchService cqlSearchService;
    private final ApprovalsSearchService approvalsSearchService;

    public DefaultDocumentStatsReportManager(CQLSearchService cqlSearchService, ApprovalsSearchService approvalsSearchService) {
        this.cqlSearchService = cqlSearchService;
        this.approvalsSearchService = approvalsSearchService;
    }

    @Override
    public DocumentStatsReport createReport(DocumentStatsReportOptions statsReportOptions) {
        DocumentStatsReport documentStatsReport = new DocumentStatsReport();
        ArrayList<String> statesNames = !statsReportOptions.getStateNames().isEmpty() ? statsReportOptions.getStateNames() : new ArrayList<String>(this.getStatesNames(statsReportOptions.getSpaceKeys()));
        for (String state : statesNames) {
            statsReportOptions.setStateName(state);
            DocumentStatsReportOptionsCqlPresenter documentStatsReportOptionsCqlPresenter = new DocumentStatsReportOptionsCqlPresenter(statsReportOptions);
            String cqlQuery = (String)documentStatsReportOptionsCqlPresenter.present().get("cqlQuery");
            SearchPageResponse search = this.cqlSearchService.search(cqlQuery, SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(0, 0), new Expansion[0]);
            documentStatsReport.addStateCount(state, search.totalSize());
        }
        return documentStatsReport;
    }

    protected Set<String> getStatesNames(List<String> spaceKeys) {
        HashSet<String> stateNames = new HashSet<String>();
        spaceKeys.forEach(space -> stateNames.addAll(this.approvalsSearchService.getSpaceStates((String)space)));
        return stateNames;
    }
}

