/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports;

import com.atlassian.confluence.importexport.resource.DownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.component.ComponentLocator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CsvExportService {
    private final BootstrapManager bootstrapManager;

    public CsvExportService(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(String csv, AbstractPage page) throws IOException {
        SimpleDateFormat dateFormatterForFileName = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
        String fileName = "page" + page.getId() + "_" + dateFormatterForFileName.format(new Date()) + "-";
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String userName = user == null ? "" : user.getName();
        DownloadResourceWriter writer = ((WritableDownloadResourceManager)ComponentLocator.getComponent(WritableDownloadResourceManager.class)).getResourceWriter(userName, fileName, ".csv");
        try (OutputStreamWriter outputStream = new OutputStreamWriter(writer.getStreamForWriting(), "UTF-8");){
            outputStream.write(csv);
            ((Writer)outputStream).flush();
        }
        String path = writer.getResourcePath();
        String webContextPath = this.bootstrapManager.getWebAppContextPath();
        if (!webContextPath.isEmpty() && path.startsWith(webContextPath)) {
            path = path.substring(webContextPath.length());
        }
        return path;
    }
}

