/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.services;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.workflow.template.LinkedTemplateManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LinkWorkflowToSpaceCategorySpacesTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(LinkWorkflowToSpaceCategorySpacesTask.class);
    private final String workflowHandle;
    private final List<String> spaceKeys;
    private int spaceCount = 0;
    private int linkedCount = 0;
    private int errorCount = 0;
    private List<String> alreadyLinkedSpaces;
    private final LinkedTemplateManager linkedTemplateManager;
    private final TransactionTemplate transactionTemplate;
    private final WorkflowService workflowService;
    private final WorkflowConfigurationManager workflowConfigurationManager;

    public LinkWorkflowToSpaceCategorySpacesTask(String workflowHandle, LinkedTemplateManager linkedTemplateManager, List<String> spaceKeys, TransactionTemplate transactionTemplate, WorkflowService workflowService, WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowHandle = workflowHandle;
        this.spaceKeys = spaceKeys;
        this.linkedTemplateManager = linkedTemplateManager;
        this.transactionTemplate = transactionTemplate;
        this.workflowService = workflowService;
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    protected void runInternal() {
        int totalSpaces = this.spaceKeys.size();
        this.progress.setTotalObjects(totalSpaces);
        log.debug("'{}' started to link workflow with '{}' workflow-handle to {} spaces", new Object[]{this.getName(), this.workflowHandle, this.spaceKeys.size()});
        this.alreadyLinkedSpaces = this.linkedTemplateManager.getLinkedSpaces(this.workflowService.getNameFromHandle(null, this.workflowHandle));
        for (String spaceKey : this.spaceKeys) {
            boolean error;
            if (!this.areWorkflowsAllowedInSpace(spaceKey)) {
                error = true;
                log.error("Error linking workflow '{}' to space '{}': Space Workflows not allowed in that space", (Object)this.workflowHandle, (Object)spaceKey);
            } else if (this.hasThisSpaceTheGlobalWorkflowLinked(spaceKey)) {
                error = true;
                log.error("Error linking workflow '{}' to space '{}': Workflow is already linked to that space", (Object)this.workflowHandle, (Object)spaceKey);
            } else {
                LinkWorkflowToSpaceTransactionCallback tc = new LinkWorkflowToSpaceTransactionCallback(spaceKey, this.workflowHandle);
                error = (Boolean)this.transactionTemplate.execute((TransactionCallback)tc);
            }
            if (error) {
                ++this.errorCount;
                log.debug("Workflow with '{}' workflow-handle failed to be linked to space with '{}' spacekey", (Object)this.workflowHandle, (Object)spaceKey);
            } else {
                ++this.linkedCount;
                log.debug("Workflow with '{}' workflow-handle linked successfully to space with '{}' spacekey", (Object)this.workflowHandle, (Object)spaceKey);
            }
            ++this.spaceCount;
            this.progress.setPercentage(this.spaceCount, totalSpaces);
            this.progress.setStatus(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.workflow.global.category.link.task.status.in-progress", (Object[])new Object[]{totalSpaces, this.linkedCount, this.errorCount}));
        }
        log.debug("'{}' finished - Workflow with '{}' workflow-handle was linked/failed '{}/{}' from a total of '{}' spaces", new Object[]{this.getName(), this.workflowHandle, this.linkedCount, this.errorCount, totalSpaces});
        if (this.errorCount == 0) {
            this.progress.setCompletedSuccessfully(true);
            this.progress.setStatus(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.workflow.global.category.link.task.status.completed.successful", (Object[])new Object[]{totalSpaces, this.linkedCount}));
        } else {
            this.progress.setCompletedSuccessfully(false);
            this.progress.setStatus(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.workflow.global.category.link.task.status.completed.errors", (Object[])new Object[]{totalSpaces, this.linkedCount, this.errorCount}));
        }
    }

    private boolean areWorkflowsAllowedInSpace(String spaceKey) {
        return this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(spaceKey);
    }

    private boolean hasThisSpaceTheGlobalWorkflowLinked(String spaceKey) {
        return this.alreadyLinkedSpaces.contains(spaceKey);
    }

    public String getName() {
        return ConfluenceActionSupport.getTextStatic((String)"com.comalatech.workflow.global.category.link.task.name");
    }

    private class LinkWorkflowToSpaceTransactionCallback
    implements TransactionCallback {
        private final String spaceKey;
        private final String workflowHandle;

        LinkWorkflowToSpaceTransactionCallback(String spaceKey, String workflowHandle) {
            this.spaceKey = spaceKey;
            this.workflowHandle = workflowHandle;
        }

        public Boolean doInTransaction() {
            try {
                LinkWorkflowToSpaceCategorySpacesTask.this.workflowService.activateWorkflow(this.spaceKey, this.workflowHandle);
                return false;
            }
            catch (WorkflowException e) {
                log.error("Error linking workflow '{}' to space '{}': {}", new Object[]{this.workflowHandle, this.spaceKey, e});
                return true;
            }
        }
    }
}

