/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentCreateEvent;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentResolveEvent;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportErrorEvent;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportSuccessEvent;
import com.comalatech.confluence.states.event.BlogPostAssignEvent;
import com.comalatech.confluence.states.event.BlogPostStateSelectEvent;
import com.comalatech.confluence.states.event.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.BlogPostTaskAssignEvent;
import com.comalatech.confluence.states.event.BlogPostTaskCompleteEvent;
import com.comalatech.confluence.states.event.BlogPostTaskCreateEvent;
import com.comalatech.confluence.states.event.BlogPostUnassignEvent;
import com.comalatech.confluence.states.event.DefaultTaskDueDateExpiredEvent;
import com.comalatech.confluence.states.event.PageAssignEvent;
import com.comalatech.confluence.states.event.PageStateSelectEvent;
import com.comalatech.confluence.states.event.PageStateTransitionEvent;
import com.comalatech.confluence.states.event.PageTaskAssignEvent;
import com.comalatech.confluence.states.event.PageTaskCompleteEvent;
import com.comalatech.confluence.states.event.PageTaskCreateEvent;
import com.comalatech.confluence.states.event.PageUnassignEvent;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.states.event.StateSelectEvent;
import com.comalatech.confluence.states.event.TaskAssignEvent;
import com.comalatech.confluence.states.event.TaskCompleteEvent;
import com.comalatech.confluence.states.event.TaskCreateEvent;
import com.comalatech.confluence.workflow.events.AllApprovalsEvent;
import com.comalatech.confluence.workflow.events.AllApproveEvent;
import com.comalatech.confluence.workflow.events.AllRejectEvent;
import com.comalatech.confluence.workflow.events.BlogPostAllApproveEvent;
import com.comalatech.confluence.workflow.events.BlogPostAllRejectEvent;
import com.comalatech.confluence.workflow.events.DefaultApprovalDueDateExpiredEvent;
import com.comalatech.confluence.workflow.events.InternalApprovalEvent;
import com.comalatech.confluence.workflow.events.PageAllApproveEvent;
import com.comalatech.confluence.workflow.events.PageAllRejectEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentCreateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentUpdateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentVersionRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowCustomEvent;
import com.comalatech.workflow.event.ApprovalDueDateExpiredEvent;
import com.comalatech.workflow.event.TaskDueDateExpiredEvent;
import com.comalatech.workflow.event.WorkflowEvent;
import com.comalatech.workflow.event.approval.ApprovalApprovedEvent;
import com.comalatech.workflow.event.approval.ApprovalRejectedEvent;
import com.comalatech.workflow.event.approval.ApprovalUnassignedEvent;
import com.comalatech.workflow.event.readack.ReadAckCompletedEvent;
import com.comalatech.workflow.event.readack.ReadAckCreatedEvent;
import com.comalatech.workflow.event.readack.ReadAckEvent;
import com.comalatech.workflow.event.readack.ReadAckOverdueEvent;
import com.comalatech.workflow.event.readack.ReadAcknowledgedEvent;

public class TriggerEvents {
    public static final String EVENT_LABEL_ADDED = "labeladded";
    public static final String EVENT_LABEL_REMOVED = "labelremoved";
    public static final String EVENT_PAGE_APPROVED = "pageapproved";
    public static final String EVENT_PAGE_REJECTED = "pagerejected";
    public static final String EVENT_PAGE_CREATED = "pagecreated";
    public static final String EVENT_PAGE_UPDATED = "pageupdated";
    public static final String EVENT_PAGE_MOVED = "pagemoved";
    public static final String EVENT_BLOG_CREATED = "newscreated";
    public static final String EVENT_BLOG_UPDATED = "newsupdated";
    public static final String EVENT_BLOG_APPROVED = "newsapproved";
    public static final String EVENT_BLOG_REJECTED = "newsrejected";
    public static final String EVENT_STATE_CHANGE = "statechanged";
    public static final String EVENT_STATE_EXPIRED = "stateexpired";
    public static final String EVENT_STATE_EXPIRY_UPDATED = "stateexpiryupdated";
    public static final String EVENT_APPROVAL_EXPIRED = "approvalexpired";
    public static final String EVENT_PAGESTATE_CHANGE = "pagestatechanged";
    public static final String EVENT_BLOGSTATE_CHANGE = "newsstatechanged";
    public static final String EVENT_PAGE_APPROVAL_ASSIGNED = "pageapprovalassigned";
    public static final String EVENT_BLOG_POST_APPROVAL_ASSIGNED = "newsapprovalassigned";
    public static final String EVENT_APPROVAL_UNASSIGNED = "approvalunassigned";
    public static final String EVENT_ATTACHMENTS_CHANGED = "attachmentschanged";
    public static final String EVENT_ATTACHMENT_ADDED = "attachmentadded";
    public static final String EVENT_ATTACHMENT_UPDATED = "attachmentupdated";
    public static final String EVENT_ATTACHMENT_REMOVED = "attachmentremoved";
    public static final String EVENT_ATTACHMENT_VERSION_REMOVED = "attachmentversionremoved";
    public static final String EVENT_TASK_CREATED = "taskcreated";
    public static final String EVENT_TASK_ASSIGNED = "taskassigned";
    public static final String EVENT_TASK_COMPLETED = "taskcompleted";
    public static final String EVENT_TASK_EXPIRED = "taskexpired";
    public static final String EVENT_PAGE_PARAMETER_UPDATE = "pageparameterupdate";
    public static final String EVENT_PAGE_COMMENT_CREATED = "pagecommentcreated";
    public static final String EVENT_PAGE_COMMENT_REMOVED = "pagecommentremoved";
    public static final String EVENT_PAGE_COMMENT_UPDATED = "pagecommentupdated";
    public static final String EVENT_INLINE_COMMENT_CREATED = "inlinecommentcreated";
    public static final String EVENT_INLINE_COMMENT_RESOLVED = "inlinecommentresolved";
    public static final String EVENT_READ_ACK_COMPLETED = "confirmationcompleted";
    public static final String EVENT_READ_ACK_CREATED = "confirmationrequested";
    public static final String EVENT_READ_ACK_OVERDUE = "confirmationdue";
    public static final String EVENT_READ_ACK_ACKNOWLEDGED = "confirmationacknowledged";
    public static final String EVENT_PDF_EXPORT_SUCCESS = "pdf-export-success";
    public static final String EVENT_PDF_EXPORT_ERROR = "pdf-export-error";

    public static String eventToString(Class event) {
        if (LabelAddEvent.class.isAssignableFrom(event)) {
            return "label is added";
        }
        if (LabelRemoveEvent.class.isAssignableFrom(event)) {
            return "label is removed";
        }
        if (PageCreateEvent.class.isAssignableFrom(event)) {
            return "page gets created";
        }
        if (PageUpdateEvent.class.isAssignableFrom(event)) {
            return "page gets updated";
        }
        if (StateSelectEvent.class.isAssignableFrom(event)) {
            return "state is selected";
        }
        if (AllApprovalsEvent.class.isAssignableFrom(event)) {
            if (ApprovalApprovedEvent.class.isAssignableFrom(event)) {
                return "content receives all approvals in state";
            }
            return "content receives all rejections in state";
        }
        if (ApprovalApprovedEvent.class.isAssignableFrom(event)) {
            return "content is approved";
        }
        if (ApprovalRejectedEvent.class.isAssignableFrom(event)) {
            return "content is rejected";
        }
        if (BlogPostCreateEvent.class.isAssignableFrom(event)) {
            return "news entry get created";
        }
        if (BlogPostUpdateEvent.class.isAssignableFrom(event)) {
            return "news entry get updated";
        }
        if (WorkflowAttachmentCreateEvent.class.isAssignableFrom(event)) {
            return "Attachment is added";
        }
        if (WorkflowAttachmentRemoveEvent.class.isAssignableFrom(event)) {
            return "Attachment is removed";
        }
        if (WorkflowAttachmentVersionRemoveEvent.class.isAssignableFrom(event)) {
            return "Attachment version is removed";
        }
        if (WorkflowAttachmentUpdateEvent.class.isAssignableFrom(event)) {
            return "Attachment is updated";
        }
        if (WorkflowAttachmentEvent.class.isAssignableFrom(event)) {
            return "Attachments are changed";
        }
        if (BlogPostAssignEvent.class.isAssignableFrom(event)) {
            return "blog post is assigned";
        }
        if (BlogPostUnassignEvent.class.isAssignableFrom(event)) {
            return "Blogpost is unassigned";
        }
        if (PageAssignEvent.class.isAssignableFrom(event)) {
            return "Page is assigned";
        }
        if (PageUnassignEvent.class.isAssignableFrom(event)) {
            return "Page is unassigned";
        }
        if (TaskAssignEvent.class.isAssignableFrom(event)) {
            return "Task is assigned";
        }
        if (TaskCompleteEvent.class.isAssignableFrom(event)) {
            return "Task is completed";
        }
        if (TaskCreateEvent.class.isAssignableFrom(event)) {
            return "Task is created";
        }
        if (TaskDueDateExpiredEvent.class.isAssignableFrom(event)) {
            return "Task Due Date Expired";
        }
        if (ApprovalDueDateExpiredEvent.class.isAssignableFrom(event)) {
            return "Approval Due Date Expired";
        }
        if (ApprovalUnassignedEvent.class.isAssignableFrom(event)) {
            return "Approval is unassigned";
        }
        if (StateExpireEvent.class.isAssignableFrom(event)) {
            return "State is expired";
        }
        if (StateExpiryUpdatedEvent.class.isAssignableFrom(event)) {
            return "State expiry date is updated";
        }
        if (WorkflowCustomEvent.class.isAssignableFrom(event)) {
            return "Custom event is fired";
        }
        if (PageStateTransitionEvent.class.isAssignableFrom(event)) {
            return "page's state changes";
        }
        if (BlogPostStateTransitionEvent.class.isAssignableFrom(event)) {
            return "blog post's state changes";
        }
        if (CommentCreateEvent.class.isAssignableFrom(event)) {
            return "A comment was added";
        }
        if (CommentRemoveEvent.class.isAssignableFrom(event)) {
            return "A comment was removed";
        }
        if (CommentUpdateEvent.class.isAssignableFrom(event)) {
            return "A comment was updated";
        }
        if (InlineCommentCreateEvent.class.isAssignableFrom(event)) {
            return "An inline comment was created";
        }
        if (InlineCommentResolveEvent.class.isAssignableFrom(event)) {
            return "An inline comment was resolved";
        }
        if (ReadAckOverdueEvent.class.isAssignableFrom(event)) {
            return "A read confirmation was overdue";
        }
        if (ReadAckCreatedEvent.class.isAssignableFrom(event)) {
            return "A read confirmation was created";
        }
        if (ReadAckCompletedEvent.class.isAssignableFrom(event)) {
            return "A read confirmation status was changed to complete";
        }
        if (ReadAcknowledgedEvent.class.isAssignableFrom(event)) {
            return "A read confirmation acknowledged occurred";
        }
        if (PdfExportSuccessEvent.class.isAssignableFrom(event)) {
            return "A pdf export success occurred";
        }
        if (PdfExportErrorEvent.class.isAssignableFrom(event)) {
            return "A pdf export error occurred";
        }
        return event.getClass().getName().substring(event.getClass().getName().lastIndexOf(".") + 1);
    }

    public static String eventToString(ConfluenceEvent event) {
        if (event instanceof LabelAddEvent) {
            return "label {{" + ((LabelEvent)event).getLabel().getName() + "}} is added";
        }
        if (event instanceof LabelRemoveEvent) {
            return "label {{" + ((LabelEvent)event).getLabel().getName() + "}} is removed";
        }
        if (event instanceof AllApprovalsEvent) {
            return TriggerEvents.allApprovalText((AllApprovalsEvent)event);
        }
        if (event instanceof WorkflowCustomEvent) {
            WorkflowCustomEvent customEvent = (WorkflowCustomEvent)event;
            return "event " + customEvent.getEventName() + " (" + (customEvent.isSuccess() ? "success" : "failure") + ") gets published";
        }
        if (event instanceof PageStateTransitionEvent) {
            PageStateTransitionEvent stateTransition = (PageStateTransitionEvent)event;
            return "page's state changes to _" + stateTransition.getState().getState() + "_";
        }
        if (event instanceof BlogPostStateTransitionEvent) {
            BlogPostStateTransitionEvent stateTransition = (BlogPostStateTransitionEvent)event;
            return "blog post's state changes to _" + stateTransition.getState().getState() + "_";
        }
        if (event instanceof ApprovalApprovedEvent) {
            return "content is approved (" + ((ApprovalApprovedEvent)event).getApprovalName() + ")";
        }
        if (event instanceof ApprovalRejectedEvent) {
            return "content is rejected (" + ((ApprovalRejectedEvent)event).getApprovalName() + ")";
        }
        return TriggerEvents.eventToString(event.getClass());
    }

    public static Class[] getTriggerEvents(ConfluenceEvent event) {
        if (event instanceof AllApproveEvent) {
            return new Class[]{BlogPostAllApproveEvent.class, PageAllApproveEvent.class};
        }
        if (event instanceof AllRejectEvent) {
            return new Class[]{BlogPostAllRejectEvent.class, PageAllRejectEvent.class};
        }
        if (event instanceof StateSelectEvent) {
            return new Class[]{PageStateSelectEvent.class, BlogPostStateSelectEvent.class};
        }
        if (event instanceof TaskCreateEvent) {
            return new Class[]{PageTaskCreateEvent.class, BlogPostTaskCreateEvent.class};
        }
        if (event instanceof TaskAssignEvent) {
            return new Class[]{PageTaskAssignEvent.class, BlogPostTaskAssignEvent.class};
        }
        if (event instanceof TaskCompleteEvent) {
            return new Class[]{PageTaskCompleteEvent.class, BlogPostTaskCompleteEvent.class};
        }
        if (event instanceof TaskDueDateExpiredEvent) {
            return new Class[]{DefaultTaskDueDateExpiredEvent.class};
        }
        if (event instanceof ApprovalDueDateExpiredEvent) {
            return new Class[]{DefaultApprovalDueDateExpiredEvent.class};
        }
        if (event instanceof StateExpireEvent) {
            return new Class[]{StateExpireEvent.class};
        }
        if (event instanceof StateExpiryUpdatedEvent) {
            return new Class[]{StateExpiryUpdatedEvent.class};
        }
        return new Class[]{event.getClass()};
    }

    public static String allApprovalText(AllApprovalsEvent event) {
        if (event instanceof AllApproveEvent) {
            return "Page/News entry receives all approvals on state";
        }
        return "Page/News entry receives all rejections on state";
    }

    public static String approvalText(ConfluenceEvent event) {
        InternalApprovalEvent approvalEvent = (InternalApprovalEvent)event;
        StringBuffer sb = new StringBuffer();
        if (approvalEvent instanceof BlogPostEvent) {
            sb.append("news entry");
        } else {
            sb.append("page");
        }
        String approvalName = approvalEvent.getApprovalCheck().getName();
        sb.append(" gets ").append(approvalEvent.isPartial() ? " partial " : "").append(" _").append(approvalName).append("_");
        if (approvalEvent instanceof ApprovalApprovedEvent) {
            sb.append(" approval");
        } else {
            sb.append(" rejection");
        }
        return sb.toString();
    }

    public static AbstractPage getPage(ConfluenceEvent e) {
        if (e instanceof LabelEvent) {
            Labelable labelable = ((LabelEvent)e).getLabelled();
            if (labelable instanceof AbstractPage) {
                return (AbstractPage)labelable;
            }
            return null;
        }
        if (e instanceof PageEvent) {
            return ((PageEvent)e).getPage();
        }
        if (e instanceof BlogPostEvent) {
            return ((BlogPostEvent)e).getBlogPost();
        }
        if (e instanceof AttachmentEvent) {
            ContentEntityObject ceo = ((AttachmentEvent)e).getContent();
            if (ceo instanceof AbstractPage) {
                return (AbstractPage)ceo;
            }
        } else {
            if (e instanceof WorkflowAttachmentEvent) {
                return ((WorkflowAttachmentEvent)e).getAbstractPage();
            }
            if (e instanceof WorkflowEvent) {
                return (AbstractPage)((WorkflowEvent)e).getContent();
            }
            if (e instanceof WorkflowCustomEvent) {
                WorkflowCustomEvent event = (WorkflowCustomEvent)e;
                return event.getPage();
            }
            if (e instanceof ReadAckEvent) {
                return (AbstractPage)((ReadAckEvent)e).getContent();
            }
            if (e instanceof ContentEvent) {
                ContentEntityObject container;
                ContentEntityObject ceo = ((ContentEvent)e).getContent();
                if (ceo instanceof AbstractPage) {
                    return (AbstractPage)ceo;
                }
                if (ceo instanceof Comment && (container = ((Comment)ceo).getContainer()) instanceof AbstractPage) {
                    return (AbstractPage)container;
                }
            }
        }
        return null;
    }

    public static Label getLabel(ConfluenceEvent event) {
        if (event == null) {
            return null;
        }
        if (event instanceof LabelEvent) {
            return ((LabelEvent)event).getLabel();
        }
        return null;
    }
}

