/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.comalatech.confluence.ipc.api.ApprovalCompletion;
import com.comalatech.confluence.ipc.api.PartialApprovalCompletion;
import com.comalatech.confluence.ipc.api.PartialRejectionCompletion;
import com.comalatech.confluence.ipc.api.RejectionCompletion;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.model.AssignedApproverImpl;
import com.comalatech.confluence.workflow.model.DueDateRecordAware;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.comalatech.workflow.model.Approval;
import com.comalatech.workflow.model.AssignedApprover;
import com.comalatech.workflow.model.Assignment;
import com.comalatech.workflow.model.Completion;
import com.comalatech.workflow.model.Rejection;
import com.comalatech.workflow.model.SignatureType;
import com.comalatech.workflow.model.StateApproval;
import com.comalatech.workflow.model.Task;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ApprovalCheck
implements Serializable,
Task,
DueDateRecordAware,
StateApproval {
    public static final ApprovalCheck[] EMPTY_ARRAY = new ApprovalCheck[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Approver[] EMPTY_APPROVERS = new Approver[0];
    private String name;
    private int version;
    private int weight;
    private int id;
    private int stateId;
    private CheckedAttachment[] attachments = new CheckedAttachment[0];
    private String caption;
    private String[] nextApprovers;
    private String[] requiredApprovers = EMPTY_STRING_ARRAY;
    private List<AssigneeHistory> assigneeHistory;
    private Approver[] approvers;
    private int minimumApproversRequired;
    private DueDateRecord dueDateRecord;
    private List<DueDateRecord> dueDateHistory;
    private transient List<AssignedApprover> assignedApprovers = null;

    public ApprovalCheck() {
        this.nextApprovers = EMPTY_STRING_ARRAY;
        this.approvers = EMPTY_APPROVERS;
        this.assigneeHistory = new ArrayList<AssigneeHistory>();
        this.dueDateHistory = new ArrayList<DueDateRecord>();
    }

    @Override
    public boolean canComplete() {
        return false;
    }

    public ApprovalCheck(String name) {
        this(name, 40, 0, null);
    }

    public ApprovalCheck(String name, int weight, int version, List attachmentsList, Approver approver) {
        this(name, weight, version, attachmentsList);
        if (approver != null) {
            this.setApprovers(new Approver[]{approver});
        }
    }

    public ApprovalCheck(String name, int weight, int version, List attachmentsList) {
        this();
        this.name = name;
        this.version = version;
        this.weight = weight;
        this.setAttachments(attachmentsList);
    }

    @Nullable
    public String getRolename(String username) {
        Optional<AssigneeHistory> optionalAssigneeHistory = this.getAssigneeHistory().stream().filter(assigneeHistory -> assigneeHistory.getAssignee() != null && assigneeHistory.getAssignee().equals(username)).reduce((a, b) -> b);
        return optionalAssigneeHistory.isPresent() ? optionalAssigneeHistory.get().getRolename() : null;
    }

    public CheckedAttachment[] getAttachments() {
        if (this.attachments == null) {
            this.attachments = new CheckedAttachment[0];
        }
        return this.attachments;
    }

    public void setRequiredApprovers(String[] requiredApprovers) {
        this.requiredApprovers = requiredApprovers;
    }

    public void addRequiredApprover(String requiredApprover, String rolename, String assignmentComment) {
        if (this.requiredApprovers == null) {
            this.requiredApprovers = new String[0];
        }
        for (String approver : this.requiredApprovers) {
            if (!approver.equalsIgnoreCase(requiredApprover)) continue;
            return;
        }
        String[] newUsers = new String[this.requiredApprovers.length + 1];
        System.arraycopy(this.requiredApprovers, 0, newUsers, 0, this.requiredApprovers.length);
        newUsers[this.requiredApprovers.length] = requiredApprover;
        this.requiredApprovers = newUsers;
        this.addAssigneeHistory(requiredApprover, rolename, assignmentComment, AssigneeHistoryType.ASSIGNMENT);
    }

    public void removeRequiredApprover(String requiredApprover, String rolename, String assignmentComment) {
        boolean found = false;
        for (String approver : this.requiredApprovers) {
            if (!approver.equals(requiredApprover)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        String[] newRequiredApprovers = new String[this.requiredApprovers.length - 1];
        int i = 0;
        for (String approver : this.requiredApprovers) {
            if (approver.equalsIgnoreCase(requiredApprover)) continue;
            newRequiredApprovers[i++] = approver;
        }
        this.requiredApprovers = newRequiredApprovers;
        this.addAssigneeHistory(requiredApprover, rolename, assignmentComment, AssigneeHistoryType.UNASSIGNMENT);
    }

    public String getAssignerUserName(String requiredApproverName) {
        boolean required = false;
        for (String requiredApprover : this.requiredApprovers) {
            if (!requiredApprover.equals(requiredApproverName)) continue;
            required = true;
            break;
        }
        if (!required) {
            return null;
        }
        ListIterator<AssigneeHistory> i = this.assigneeHistory.listIterator(this.assigneeHistory.size());
        while (i.hasPrevious()) {
            AssigneeHistory assignment = i.previous();
            if (!TextUtils.stringSet((String)assignment.getAssignee()) || !assignment.getAssignee().equals(requiredApproverName)) continue;
            return assignment.getPerformer();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isApproved() {
        if (this.approvers.length == 0) {
            return false;
        }
        if (this.requiredApprovers.length == 0) {
            return this.makeSureNoRequiredApproversHaveAllApproved();
        }
        if (this.lastApprovalOfRequiredApproversIsReject()) {
            return false;
        }
        return this.validateMinimunRequiredApproversCheck();
    }

    private boolean validateMinimunRequiredApproversCheck() {
        return this.minimumApproversRequired == 0 || this.approvers.length >= this.minimumApproversRequired;
    }

    private boolean lastApprovalOfRequiredApproversIsReject() {
        for (String requiredApprover : this.requiredApprovers) {
            Approver approver = this.getLatestApprover(requiredApprover);
            if (approver != null && approver.isApproved()) continue;
            return true;
        }
        return false;
    }

    private boolean makeSureNoRequiredApproversHaveAllApproved() {
        Approver[] mostRecentApprovers;
        for (Approver approver : mostRecentApprovers = this.getMostRecentApprovers()) {
            if (approver.isApproved()) continue;
            return false;
        }
        return this.minimumApproversRequired == 0 || mostRecentApprovers.length >= this.minimumApproversRequired;
    }

    public Approver getLatestApprover(String userId) {
        if (this.approvers != null) {
            for (int i = this.approvers.length - 1; i >= 0; --i) {
                Approver approver = this.approvers[i];
                if (!approver.getUser().equals(userId)) continue;
                return approver;
            }
        }
        return null;
    }

    public boolean isRejected(boolean all) {
        if (this.requiredApprovers.length == 0) {
            return this.isRejectedByAnyApprover();
        }
        if (all) {
            return this.isRejectedByAllRequiredApprovers();
        }
        return this.isRejectedByAnyRequiredApprover();
    }

    private boolean isRejectedByAnyApprover() {
        Approver[] mostRecentApprovers = this.getMostRecentApprovers();
        if (mostRecentApprovers.length > 0) {
            for (Approver approver : mostRecentApprovers) {
                if (!approver.isApproved()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isRequiredApprover(String userName) {
        for (String requiredApprover : this.requiredApprovers) {
            if (!requiredApprover.equalsIgnoreCase(userName)) continue;
            return true;
        }
        return false;
    }

    private boolean isRejectedByAnyRequiredApprover() {
        for (int i = 0; i < this.approvers.length; ++i) {
            Approver approver = this.approvers[i];
            if (approver.isApproved() || this.hasApproved(i, approver.getUser())) continue;
            return true;
        }
        return false;
    }

    private boolean isRejectedByAllRequiredApprovers() {
        for (String requiredApprover : this.requiredApprovers) {
            boolean found = false;
            for (int j = this.approvers.length - 1; j >= 0; --j) {
                Approver approver = this.approvers[j];
                if (!approver.getUser().equals(requiredApprover)) continue;
                if (approver.isApproved()) {
                    return false;
                }
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean hasApproved(int current, String user) {
        for (int i = this.approvers.length - 1; i > current; --i) {
            Approver approver = this.approvers[i];
            if (!approver.getUser().equals(user)) continue;
            return approver.isApproved();
        }
        return false;
    }

    public List<String> getPendingApprovers(boolean includeRejectors) {
        ArrayList<String> pending = new ArrayList<String>();
        for (String requiredApprover : this.requiredApprovers) {
            Approver approver = this.getMostRecentApprover(requiredApprover);
            if (approver != null && (!includeRejectors || approver.isApproved())) continue;
            pending.add(requiredApprover);
        }
        return pending;
    }

    @Override
    public List<String> getPendingApprovers() {
        return this.getPendingApprovers(false);
    }

    public String[] getPendingApproversArray(boolean includeRejectors) {
        return this.getPendingApprovers(includeRejectors).toArray(new String[0]);
    }

    public boolean appendApprover(Approver approver) {
        if (this.requiredApprovers.length >= 1 || this.minimumApproversRequired > 1) {
            Approver recent = this.getMostRecentApprover(approver.getUser());
            if (recent == null || recent.isApproved() != approver.isApproved()) {
                Approver[] newApprovers = new Approver[this.approvers.length + 1];
                System.arraycopy(this.approvers, 0, newApprovers, 0, this.approvers.length);
                newApprovers[this.approvers.length] = approver;
                this.approvers = newApprovers;
            }
            return true;
        }
        return false;
    }

    private Approver getMostRecentApprover(String approverName) {
        for (int i = this.approvers.length - 1; i >= 0; --i) {
            Approver approver = this.approvers[i];
            if (!approver.getUser().equals(approverName)) continue;
            return approver;
        }
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    public String getCaption() {
        return this.caption;
    }

    public String[] getNextApprovers() {
        return this.nextApprovers;
    }

    public void setNextApprovers(String[] nextApprovers) {
        this.nextApprovers = nextApprovers;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setAttachments(List attachmentsList) {
        if (attachmentsList != null) {
            this.attachments = new CheckedAttachment[attachmentsList.size()];
            int i = 0;
            for (Attachment attachment : attachmentsList) {
                this.attachments[i] = new CheckedAttachment(attachment.getId(), attachment.getVersion());
                ++i;
            }
            Arrays.sort(this.attachments);
        }
    }

    public void setApprovers(Approver[] approvers) {
        this.approvers = approvers;
    }

    public void addApprover(Approver approver) {
        if (this.approvers == null || this.approvers.length == 0) {
            this.setApprovers(new Approver[]{approver});
        } else {
            Approver[] newApprovers = new Approver[this.approvers.length + 1];
            System.arraycopy(this.approvers, 0, newApprovers, 0, this.approvers.length);
            newApprovers[this.approvers.length] = approver;
            this.approvers = newApprovers;
        }
    }

    public Approver[] getApprovers() {
        return this.approvers;
    }

    @Override
    @JsonIgnore
    public List<Approval> getApprovals() {
        ArrayList<Approval> returnList = new ArrayList<Approval>(this.approvers.length);
        Collections.addAll(returnList, this.approvers);
        return returnList;
    }

    @JsonIgnore
    public List<Approval> getMostRectentApprovals() {
        Approver[] mostRecentApprovers = this.getMostRecentApprovers();
        ArrayList<Approval> returnList = new ArrayList<Approval>(mostRecentApprovers.length);
        Collections.addAll(returnList, mostRecentApprovers);
        return returnList;
    }

    public Approver[] getMostRecentApprovers() {
        ArrayList<Approver> recentApprovers = new ArrayList<Approver>(this.approvers.length);
        HashSet<String> approverNames = new HashSet<String>();
        for (int i = this.approvers.length - 1; i >= 0; --i) {
            Approver approver = this.approvers[i];
            if (approverNames.contains(approver.getUser())) continue;
            recentApprovers.add(0, approver);
            approverNames.add(approver.getUser());
        }
        return recentApprovers.toArray(new Approver[recentApprovers.size()]);
    }

    public List<Approver> getLatestApprovers(boolean approved) {
        Map<String, Optional<Approver>> usersLastApprovalMap = Arrays.stream(this.approvers).collect(Collectors.groupingBy(Approver::getUserName, Collectors.maxBy(Comparator.comparing(Approver::getDate))));
        return usersLastApprovalMap.values().stream().filter(Optional::isPresent).map(Optional::get).filter(approver -> approver.isApproved() == approved).sorted(Comparator.comparing(Approver::getDate)).collect(Collectors.toList());
    }

    public Approver getLastApprover() {
        if (this.approvers != null && this.approvers.length > 0) {
            return this.approvers[this.approvers.length - 1];
        }
        return null;
    }

    public String[] getRequiredApprovers() {
        return this.requiredApprovers;
    }

    @Override
    @JsonIgnore
    public List<String> getAssignees() {
        return Arrays.asList(this.requiredApprovers);
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public int getAttachmentVersion(long attachmentId) {
        if (this.attachments == null) {
            return 0;
        }
        int ix = Arrays.binarySearch(this.attachments, new CheckedAttachment(attachmentId, 0));
        if (ix < 0) {
            return 0;
        }
        return this.attachments[ix].version;
    }

    public boolean isSameVersion(ApprovalCheck other) {
        if (other == null || this.version != other.getVersion() || this.attachments == null || other.attachments == null || this.attachments.length != other.attachments.length) {
            return false;
        }
        for (CheckedAttachment attachment : this.attachments) {
            if (other.getAttachmentVersion(attachment.id) == attachment.version) continue;
            return false;
        }
        return true;
    }

    public boolean isCheckUpToDate(AbstractPage page, PageState state, boolean checkAttachments, AttachmentManager attachmentManager) {
        if (page.getVersion() != this.version) {
            return false;
        }
        if (state != null && this.stateId != state.getId()) {
            return false;
        }
        if (!checkAttachments) {
            return true;
        }
        List pageAttachments = attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page.getLatestVersion());
        if (this.attachments == null) {
            return pageAttachments.isEmpty();
        }
        if (pageAttachments.size() != this.attachments.length) {
            return false;
        }
        if (this.attachments.length == 0) {
            return true;
        }
        for (Object pageAttachment : pageAttachments) {
            Attachment attachment = (Attachment)pageAttachment;
            int ix = Arrays.binarySearch(this.attachments, new CheckedAttachment(attachment.getId(), 0));
            if (ix < 0) {
                return false;
            }
            if (attachment.getVersion() == this.attachments[ix].version) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "ApprovalCheck{name='" + this.name + '\'' + ", version=" + this.version + ", weight=" + this.weight + ", id=" + this.id + ", stateId=" + this.stateId + ", attachments=" + (this.attachments == null ? null : Arrays.asList(this.attachments)) + ", approvers=" + Arrays.asList(this.approvers) + ", requiredApprovers=" + Arrays.asList(this.requiredApprovers) + ", assigneeHistory=" + this.assigneeHistory + ", minimumApproversRequired=" + this.minimumApproversRequired + ", dueDate=" + this.dueDateRecord + ", dueDateHistories= " + this.dueDateHistory + '}';
    }

    public int getWeight() {
        return this.weight;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getStateId() {
        return this.stateId;
    }

    public void setState(PageState pageState) {
        if (pageState != null) {
            this.stateId = pageState.getId();
        }
    }

    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public void setCheckedAttachments(List checkedAttachments) {
        this.attachments = checkedAttachments == null || checkedAttachments.size() == 0 ? new CheckedAttachment[0] : checkedAttachments.toArray(new CheckedAttachment[checkedAttachments.size()]);
    }

    public CheckedAttachment createCheckedAttachment(long id, int version) {
        return new CheckedAttachment(id, version);
    }

    public Approval getLastApproval() {
        Approver approver = this.getLastApprover();
        if (approver == null || !approver.isApproved()) {
            return null;
        }
        if (this.isApproved()) {
            return new ApprovalCompletion(this.name, this.id, approver.getUser(), approver.getDate(), approver.getComment(), approver.getSignatureType());
        }
        return new PartialApprovalCompletion(this.name, this.id, approver.getUser(), approver.getDate(), approver.getComment(), approver.getSignatureType());
    }

    public Rejection getLastRejection() {
        Approver approver = this.getLastApprover();
        if (approver == null || approver.isApproved()) {
            return null;
        }
        if (this.isRejected(true)) {
            return new RejectionCompletion(this.name, this.id, approver.getUser(), approver.getDate(), approver.getComment(), approver.getSignatureType());
        }
        return new PartialRejectionCompletion(this.name, this.id, approver.getUser(), approver.getDate(), approver.getComment(), approver.getSignatureType());
    }

    public String lastActivityToString() {
        StringBuffer sb = new StringBuffer(this.name).append(" ");
        Approver approver = this.getLastApprover();
        if (approver != null) {
            if (approver.isApproved()) {
                sb.append("approved ");
            } else {
                sb.append("rejected ");
            }
            sb.append("by ").append(approver.getUser());
            if (TextUtils.stringSet((String)approver.getComment())) {
                sb.append(" (").append(approver.getComment().replaceAll("\n", "")).append(")");
            }
        }
        return sb.toString();
    }

    public int getMinimumApproversRequired() {
        return this.minimumApproversRequired;
    }

    public void setMinimumApproversRequired(int minimumApproversRequired) {
        this.minimumApproversRequired = minimumApproversRequired;
    }

    public List<AssignedApprover> getActualApproversAndRequiredApprovers(String myUserName, SignatureType signature, boolean canMark) {
        if (this.assignedApprovers != null) {
            return this.assignedApprovers;
        }
        this.assignedApprovers = new ArrayList<AssignedApprover>();
        if (this.requiredApprovers.length == 0) {
            return this.assignedApprovers;
        }
        HashSet<String> approverNames = new HashSet<String>();
        for (int i = this.approvers.length - 1; i >= 0; --i) {
            if (approverNames.contains(this.approvers[i].getUser())) continue;
            approverNames.add(this.approvers[i].getUser());
            this.assignedApprovers.add(new AssignedApproverImpl(this.approvers[i], this.name, signature, canMark && this.approvers[i].getUser().equalsIgnoreCase(myUserName)));
        }
        for (String requiredApprover : this.requiredApprovers) {
            if (approverNames.contains(requiredApprover)) continue;
            approverNames.add(requiredApprover);
            this.assignedApprovers.add(new AssignedApproverImpl(requiredApprover, this.name, signature, canMark && requiredApprover.equalsIgnoreCase(myUserName)));
        }
        return this.assignedApprovers;
    }

    protected void addAssigneeHistory(String assignee, String rolename, String comment, AssigneeHistoryType type) {
        AssigneeHistory history = new AssigneeHistory(WorkflowAuthenticatedUserThreadLocal.getUsername(), new Date(), assignee, rolename, comment, type);
        if (this.assigneeHistory == null) {
            this.assigneeHistory = new ArrayList<AssigneeHistory>();
        }
        this.assigneeHistory.add(history);
    }

    public void setAssigneeHistory(List<AssigneeHistory> history) {
        this.assigneeHistory = history;
    }

    public List<AssigneeHistory> getAssigneeHistory() {
        return this.assigneeHistory;
    }

    public List<? extends com.comalatech.confluence.states.model.Assignment> getAssignmentHistory() {
        return this.assigneeHistory;
    }

    @Override
    @JsonIgnore
    public List<? extends Completion> getCompletions() {
        return Arrays.asList(this.approvers);
    }

    @Override
    public String getOutcome() {
        if (this.isApproved()) {
            return "approved";
        }
        if (this.isRejected(true)) {
            return "rejected";
        }
        return null;
    }

    @Override
    public boolean isCompleted() {
        return this.isApproved();
    }

    @Override
    public Completion getLastCompletion() {
        return this.getLastApprover();
    }

    @Override
    public String getActivityId() {
        return String.valueOf(this.id);
    }

    @Override
    public String getPerformer() {
        if (this.getLastApprover() != null) {
            return this.getLastApprover().getUserName();
        }
        return null;
    }

    @Override
    public String getUserName() {
        return this.getPerformer();
    }

    @Override
    public Date getDate() {
        if (this.getLastApprover() != null) {
            return this.getLastApprover().getDate();
        }
        return null;
    }

    @Override
    public String getComment() {
        if (this.getLastApprover() != null) {
            return this.getLastApprover().getComment();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalCheck check = (ApprovalCheck)o;
        if (this.id != check.id) {
            return false;
        }
        if (this.version != check.version) {
            return false;
        }
        if (this.weight != check.weight) {
            return false;
        }
        if (this.stateId != check.stateId) {
            return false;
        }
        if (this.minimumApproversRequired != check.minimumApproversRequired) {
            return false;
        }
        if (!Arrays.equals(this.approvers, check.approvers)) {
            return false;
        }
        if (!Arrays.equals(this.attachments, check.attachments)) {
            return false;
        }
        if (!Objects.equals(this.name, check.name)) {
            return false;
        }
        if (!Arrays.equals(this.requiredApprovers, check.requiredApprovers)) {
            return false;
        }
        if (!this.assigneeHistory.equals(check.getAssigneeHistory())) {
            return false;
        }
        if (!Objects.equals(this.dueDateRecord, check.dueDateRecord)) {
            return false;
        }
        return Objects.equals(this.dueDateHistory, check.dueDateHistory);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.version;
        result = 31 * result + this.weight;
        result = 31 * result + this.id;
        result = 31 * result + this.minimumApproversRequired;
        result = 31 * result + (this.attachments != null ? Arrays.asList(this.attachments).hashCode() : 0);
        result = 31 * result + (this.requiredApprovers != null ? Arrays.asList(this.requiredApprovers).hashCode() : 0);
        result = 31 * result + (this.approvers != null ? Arrays.asList(this.approvers).hashCode() : 0);
        result = 31 * result + (this.assigneeHistory != null ? this.assigneeHistory.hashCode() : 0);
        result = 31 * result + (this.dueDateRecord != null ? this.dueDateRecord.hashCode() : 0);
        result = 31 * result + (this.dueDateHistory != null ? this.dueDateHistory.hashCode() : 0);
        return result;
    }

    @Override
    @JsonIgnore
    public List<? extends Assignment> getAssignments() {
        return this.assigneeHistory;
    }

    @Override
    public Assignment getLastAssignment() {
        return this.getCurrentAssignment();
    }

    @Override
    public Assignment getCurrentAssignment() {
        if (this.assigneeHistory.size() > 0) {
            return this.assigneeHistory.get(this.assigneeHistory.size() - 1);
        }
        return null;
    }

    @Override
    public Date getDueDate() {
        if (this.dueDateRecord != null) {
            return this.dueDateRecord.getDueDate();
        }
        return null;
    }

    @Override
    public DueDateRecord getCurrentDueDate() {
        return this.dueDateRecord;
    }

    @Override
    public ApprovalCheck addDueDateHistory(DueDateRecord dueDateRecord) {
        this.dueDateHistory.add(dueDateRecord);
        return this;
    }

    @Override
    public void setDueDateHistory(List<DueDateRecord> dueDateHistory) {
        this.dueDateHistory = dueDateHistory;
    }

    @Override
    public List<DueDateRecord> getDueDateHistory() {
        return this.dueDateHistory;
    }

    @Override
    public void setCurrentDueDate(DueDateRecord dueDateRecord) {
        this.dueDateRecord = dueDateRecord;
    }

    public static class AssigneeHistory
    extends com.comalatech.confluence.states.model.Assignment {
        AssigneeHistoryType type;

        public AssigneeHistory() {
        }

        public AssigneeHistory(String user, Date date, String assignee, String rolename, String comment, AssigneeHistoryType type) {
            super(user, date, assignee, rolename, null, null);
            this.type = type;
            this.setComment(comment);
        }

        @Override
        public String getActivityKey() {
            if (AssigneeHistoryType.UNASSIGNMENT.equals((Object)this.type)) {
                return "approval-unassignment";
            }
            return "approval-assignment";
        }

        public AssigneeHistoryType getType() {
            return this.type;
        }

        public void setType(AssigneeHistoryType type) {
            this.type = type;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AssigneeHistory other = (AssigneeHistory)obj;
            return this.type == other.type;
        }
    }

    public static enum AssigneeHistoryType {
        ASSIGNMENT,
        UNASSIGNMENT;

    }

    public class CheckedAttachment
    implements Comparable {
        public long id;
        public int version;

        public CheckedAttachment() {
        }

        public CheckedAttachment(long id, int version) {
            this.id = id;
            this.version = version;
        }

        public int compareTo(Object o) {
            long id2 = ((CheckedAttachment)o).id;
            return Long.compare(this.id, id2);
        }

        public long getId() {
            return this.id;
        }

        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return "CheckedAttachment{id=" + this.id + ", version=" + this.version + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckedAttachment that = (CheckedAttachment)o;
            if (this.id != that.id) {
                return false;
            }
            return this.version == that.version;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + this.version;
            return result;
        }
    }
}

