/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActions.services.model.search;

import com.comalatech.confluence.documentActions.services.model.search.ActionTypes;
import com.comalatech.confluence.documentActions.services.model.search.SortingFields;
import com.comalatech.confluence.documentActions.services.model.search.SortingOrder;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlGroup;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlOperators;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SearchQuery {
    private final String cql;
    private final String expand;
    private final int pageNumber;
    private final int pageLimit;
    private final List<SortingFields> sortingFields;
    private final SortingOrder ordering;

    private SearchQuery(String cql, String expand, int pageNumber, int pageLimit, List<SortingFields> sortingFields, SortingOrder ordering) {
        this.cql = cql;
        this.expand = expand;
        this.pageNumber = pageNumber;
        this.pageLimit = pageLimit;
        this.sortingFields = sortingFields;
        this.ordering = ordering;
    }

    public String getCql() {
        return this.cql;
    }

    public String getExpand() {
        return this.expand;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public List<SortingFields> getSortingFields() {
        return this.sortingFields;
    }

    public SortingOrder getOrdering() {
        return this.ordering;
    }

    public static class Builder {
        public static final int DEFAULT_PAGE_NUMBER = 0;
        public static final int DEFAULT_PAGE_LIMIT = 20;
        public static final List<SortingFields> DEFAULT_SORTING_FIELDS = Arrays.asList(SortingFields.DUE_DATE, SortingFields.ASSIGNMENT_DATE);
        public static final SortingOrder DEFAULT_SORTING_ORDER = SortingOrder.ASCENDING;
        private final CqlGroup cqlGroup = new CqlGroup().joinOperator(CqlOperators.LogicalOperators.OR);
        private final Set<String> expandFields = new HashSet<String>();
        private int pageNumber = 0;
        private int pageLimit = 20;
        private List<SortingFields> sortingFields = DEFAULT_SORTING_FIELDS;
        private SortingOrder sortingOrder = DEFAULT_SORTING_ORDER;
        private List<ActionTypes> typeFilters = Arrays.asList(ActionTypes.values());
        private String userkey = "";

        public Builder withPageNumber(int pageNumber) {
            this.pageNumber = pageNumber < 0 ? 0 : pageNumber;
            return this;
        }

        public Builder withPageLimit(int pageLimit) {
            this.pageLimit = pageLimit <= 0 ? 20 : pageLimit;
            return this;
        }

        public Builder withSortingFields(String sortingFields) {
            ArrayList<SortingFields> sortings = new ArrayList<SortingFields>();
            for (String field : MiscUtils.splitAndTrim(sortingFields)) {
                Optional<SortingFields> searchSortingOpt = SortingFields.fromString(field);
                searchSortingOpt.ifPresent(sortings::add);
            }
            if (!sortings.isEmpty()) {
                this.sortingFields = sortings;
            }
            return this;
        }

        public Builder withSortingOrder(String sortingOrder) {
            Optional<SortingOrder> searchSortingOrder = SortingOrder.fromString(sortingOrder);
            searchSortingOrder.ifPresent(sorting -> {
                this.sortingOrder = sorting;
            });
            return this;
        }

        public Builder withTypes(String types) {
            ArrayList<ActionTypes> typesToFilter = new ArrayList<ActionTypes>();
            for (String type : MiscUtils.splitAndTrim(types)) {
                Optional<ActionTypes> actionTypeOpt = ActionTypes.fromString(type);
                actionTypeOpt.ifPresent(typesToFilter::add);
            }
            if (!typesToFilter.isEmpty()) {
                this.typeFilters = typesToFilter;
            }
            return this;
        }

        public Builder withUserkey(String userkey) {
            this.userkey = userkey;
            return this;
        }

        private void addActionToCql(String actionCqlField, String actionExpandedField) {
            this.cqlGroup.addCqlElement(new CqlParam(actionCqlField, Collections.singletonList(this.userkey)));
            this.expandFields.add(actionExpandedField);
        }

        public SearchQuery build() {
            this.typeFilters.forEach(type -> this.addActionToCql(type.getCqlField(), type.getExpandedField()));
            return new SearchQuery(this.cqlGroup.toCqlString(), String.join((CharSequence)",", this.expandFields), this.pageNumber, this.pageLimit, this.sortingFields, this.sortingOrder);
        }
    }
}

