/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    /* AJS toInit Wrapper with common implementations */
    CW.toInit(function () {
        AJS.$(document).on('click', '#cw-button-copy', function() {
            var textToCopy = $('#cw-copy-me').text();
            var button = $('#cw-button-copy');
            var icon = button.children().first();

            function cwBtnAnimation() {
                button.children()
                    .last()
                    .text(CW.I18n.getText('comalatech.awp.global.migration.assessment.enabled.btn.copied'));
                button.addClass('visible');
                icon.addClass('aui-iconfont-check-circle-filled copied');
                setTimeout(function() {
                    button.children()
                        .last()
                        .text(CW.I18n.getText('comalatech.awp.global.migration.assessment.enabled.btn.copy'));
                    button.removeClass('visible');
                    icon.removeClass('aui-iconfont-check-circle-filled copied');
                }, 3000);
            };

            if (window.clipboardData) {
                window.clipboardData.setData("Text", textToCopy);
                cwBtnAnimation();
            } else {
                $.when(navigator.clipboard.writeText(textToCopy)).done(function () {
                    cwBtnAnimation();
                });
            }
        });
    });
});
