/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};

Adhoc.Workflow = Adhoc.Workflow || {};

(function ($) {

    Adhoc.Workflow.workflowAction = function() {
        var workflowButton = $("#adhocWorkflowsLink");
        $("#add-menu-link").click();
        workflowButton.css("display","block").css("visibility","inherit").click();
        return false;
    };

    Adhoc.Workflow.addApprovalAction = function() {
        var workflowButton = $("#adhocWorkflowsLink");
        $("#add-menu-link").click();
        workflowButton.css("display","block").css("visibility","inherit").addClass("approvalworkflow").click();
        return false;
    };

    Adhoc.Workflow.doAddWorkflow = function() {
        var form = $(this);
        var workflowRequest = {
            workflowId: form.find("select").val(),
            stateNames: form.find("input.state-names").val()
        };
        Adhoc.submitProgress($(this).parents(".adhoc"));
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/workflow/" + AJS.params.pageId + "/add",
            data: JSON.stringify(workflowRequest),
            success: function (pageStatus, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    $("#addAdhocWorkflow").hide();
                    Adhoc.Workflow.setState(pageStatus);
                }
                Adhoc.dialog.hide();
            },
            error: Adhoc.errorHandler
        });
        return false;
    }

    Adhoc.Workflow.doAddApprovalWorkflow = function() {
        var form = $(this);
        var workflowRequest = {
            workflowId: 0
        };
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/workflow/" +
                    AJS.params.pageId + "/add?default=true",
            data: JSON.stringify(workflowRequest),
            success: function (pageStatus, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    $("#addAdhocWorkflow").hide();
                    $("#addApprovalWorkflow").hide();
                    Adhoc.Workflow.setState(pageStatus);
                }
                Adhoc.dialog.hide();
                $("#adhocWorkflowsLink").click();
            },
            error: Adhoc.errorHandler
        });
        return false;
    }

    Adhoc.Workflow.doSelectTemplate = function() {
        var workflowId = $(this).val();
        var form = $(this).parents("form");
        if (workflowId == 0) {
            form.addClass("adhoc");
        } else {
            form.removeClass("adhoc");
        }
    };

    Adhoc.Workflow.doTemplatesDialog = function(response, $contents, jqXHR) {
        $contents.empty();
        $contents.append(AJS.template.load("adhocworkflows-select").fill());
        $contents.find(".close-dialog").click(Adhoc.doHidePopup);
        $contents.find("select").change(Adhoc.Workflow.doSelectTemplate);
        if (jqXHR.status != 200) {
            return;
        }
        var templates = response.templates;
        for (i = 0; i < templates.length;i++) {
            $contents.find("#select-workflow-templates").append(AJS.template.load("adhocworkflows-select-template").fill(templates[i]));
        }
        $contents.find("#select-workflow-templates").append(AJS.template.load("adhocworkflows-adhoc-template").fill());
        $contents.find("form").submit(Adhoc.Workflow.doAddWorkflow);
    }

})(AJS.$);