/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.content;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import org.randombits.confluence.filtering.param.BaseParameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.support.LinkAssistant;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceEntityParameter
extends BaseParameter<ConfluenceEntityObject> {
    public static final String SELF = "@self";
    public static final String PARENT = "@parent";
    public static final String HOME = "@home";

    public ConfluenceEntityParameter(String defaultValue, String ... names) {
        super(defaultValue, names);
    }

    public ConfluenceEntityObject findEntity(MacroInfo info) throws ParameterException {
        return (ConfluenceEntityObject)this.findValue(info);
    }

    @Override
    protected ConfluenceEntityObject findObject(String paramValue, MacroInfo info) throws ParameterException {
        if (paramValue == null) {
            return null;
        }
        if (SELF.equals(paramValue)) {
            return info.getContent();
        }
        if (PARENT.equals(paramValue)) {
            if (info.getContent() instanceof Page) {
                return ((Page)info.getContent()).getParent();
            }
            return null;
        }
        if (HOME.equals(paramValue)) {
            Space space;
            if (info.getContent() instanceof SpaceContentEntityObject && (space = ((SpaceContentEntityObject)info.getContent()).getSpace()) != null) {
                return space.getHomePage();
            }
            return null;
        }
        return LinkAssistant.getInstance().getLinkedEntity(info.getPageContext(), paramValue);
    }
}

