/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.supplier;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.Iterator;
import java.util.List;
import org.randombits.confluence.supplier.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfluenceSupplier
implements Supplier {
    private UserAccessor userAccessor;
    private BootstrapManager bootstrapManager;
    private PermissionManager permissionManager;
    private LabelManager labelManager;
    private SpaceManager spaceManager;

    protected UserAccessor getUserAccessor() {
        if (this.userAccessor == null) {
            this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        }
        return this.userAccessor;
    }

    protected BootstrapManager getBootstrapManager() {
        if (this.bootstrapManager == null) {
            this.bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
        }
        return this.bootstrapManager;
    }

    protected String getContextPath() {
        return this.getBootstrapManager().getWebAppContextPath();
    }

    protected <T> List<T> getPermittedObjects(List<T> contentList) {
        if (contentList != null) {
            Iterator<T> i = contentList.iterator();
            while (i.hasNext()) {
                T content = i.next();
                if (this.getPermissionManager().hasPermission(AbstractConfluenceSupplier.getCurrentUser(), Permission.VIEW, content)) continue;
                i.remove();
            }
        }
        return contentList;
    }

    protected static User getCurrentUser() {
        return AuthenticatedUserThreadLocal.getUser();
    }

    protected PermissionManager getPermissionManager() {
        if (this.permissionManager == null) {
            this.permissionManager = (PermissionManager)ContainerManager.getComponent((String)"permissionManager");
        }
        return this.permissionManager;
    }

    public LabelManager getLabelManager() {
        if (this.labelManager == null) {
            this.labelManager = (LabelManager)ContainerManager.getComponent((String)"labelManager");
        }
        return this.labelManager;
    }

    protected List<Label> getPermittedLabels(List<Label> labels) {
        if (labels != null) {
            String username;
            Iterator<Label> i = labels.iterator();
            User user = AbstractConfluenceSupplier.getCurrentUser();
            String string = username = user != null ? user.getName() : null;
            while (i.hasNext()) {
                Label rel = i.next();
                if (rel.isVisibleTo(username)) continue;
                i.remove();
            }
        }
        return labels;
    }

    protected SpaceManager getSpaceManager() {
        if (this.spaceManager == null) {
            this.spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
        }
        return this.spaceManager;
    }
}

