/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.NotificationService;
import com.atlassian.user.User;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import com.comalatech.confluence.workflow.mywork.AdhocInAppNotificationService;
import com.comalatech.confluence.workflow.mywork.NotificationServiceAccessor;
import com.comalatech.confluence.workflow.mywork.NotificationServiceHolder;
import com.comalatech.confluence.workflow.mywork.notification.AdhocNotification;
import java.util.List;

public class AdhocInAppNotificationServiceImpl
implements AdhocInAppNotificationService {
    protected final UserAccessor userAccessor;
    protected final HostApplication hostApplication;
    protected final SettingsManager settingsManager;
    protected final NotificationServiceAccessor notificationServiceAccessor;
    protected BootstrapManager bootstrapManager;
    protected NotificationServiceHolder notificationServiceHolder;
    protected NotificationService notificationService;
    protected static final String APPLICATION_KEY = "com.comalatech.confluence.workflow.mywork";

    public AdhocInAppNotificationServiceImpl(UserAccessor userAccessor, NotificationServiceAccessor notificationServiceAccessor, HostApplication hostApplication, SettingsManager settingsManager, BootstrapManager bootstrapManager) {
        this.userAccessor = userAccessor;
        this.notificationServiceAccessor = notificationServiceAccessor;
        this.hostApplication = hostApplication;
        this.settingsManager = settingsManager;
        this.bootstrapManager = bootstrapManager;
    }

    protected boolean isNotificationServiceAvailable() {
        this.notificationServiceHolder = this.notificationServiceAccessor.getNotificationService();
        if (this.notificationServiceHolder != null) {
            this.notificationService = (NotificationService)this.notificationServiceHolder.getNotificationService();
            return this.notificationService != null;
        }
        return false;
    }

    @Override
    public void sendNotification(AdhocNotification adhocNotification, List<String> usernames) {
        if (usernames != null && this.isNotificationServiceAvailable()) {
            for (String username : usernames) {
                Notification notification = new NotificationBuilder().application(APPLICATION_KEY).itemTitle(adhocNotification.getItemTitle()).itemUrl(adhocNotification.getItemUrlPath(username)).itemIconUrl(adhocNotification.getIconUrlPath()).description(adhocNotification.getDescription()).entity(adhocNotification.getEntity()).action(adhocNotification.getAction()).globalId(adhocNotification.globalId()).groupingId(adhocNotification.getGroupingId()).metadata(adhocNotification.getMetadata(username)).iconUrl(this.getUserAvatarUrl(AuthenticatedUserThreadLocal.get())).applicationLinkId(this.hostApplication.getId().get()).createNotification();
                this.sendNotification(username, notification);
            }
        }
    }

    protected void sendNotification(String username, Notification notification) {
        this.notificationService.createOrUpdate(username, notification);
    }

    protected String getUserAvatarUrl(ConfluenceUser user) {
        String pictureUrl = "/images/icons/profilepics/default.gif";
        if (user != null && !WorkflowsFeatureManagerImpl.isWorkflowsUser(user.getName())) {
            pictureUrl = this.userAccessor.getUserProfilePicture((User)user).getUriReference();
            pictureUrl = pictureUrl.substring(this.bootstrapManager.getWebAppContextPath().length());
        }
        return pictureUrl;
    }

    protected String getBaseUrl() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }
}

