/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.macros.AbstractWorkflowElementMacro;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.HasViewWorkflowPermission;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.workflow.model.SignatureType;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ApprovalMacro
extends AbstractWorkflowElementMacro {
    public static final String PARAM_WEIGHT = "weight";
    public static final String PARAM_FINAL = "final";
    public static final String PARAM_SHOWINPAGES = "showinpages";
    public static final String PARAM_SHOWINBLOGS = "showinnews";
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_CREDENTIALS = "credentials";
    public static final String PARAM_ASSIGNABLE = "assignable";
    public static final String PARAM_REMEMBERASSIGNEES = "rememberassignees";
    public static final String PARAM_APPROVELABEL = "approvelabel";
    public static final String PARAM_REJECTLABEL = "rejectlabel";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_ROLES = "roles";

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public boolean allowsAnonymousUser() {
        return false;
    }

    private Map makeMacroParams() {
        HashMap<String, String> macroParams = new HashMap<String, String>();
        macroParams.put(PARAM_WEIGHT, Integer.toString(40));
        macroParams.put(PARAM_FINAL, "false");
        macroParams.put(PARAM_SHOWINPAGES, "true");
        macroParams.put(PARAM_SHOWINBLOGS, "true");
        macroParams.put(PARAM_CREDENTIALS, "0");
        macroParams.put("minimum", "1");
        macroParams.put("caption", ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.next-approver"));
        macroParams.put("hint", ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.approvals.next-approver.hint"));
        macroParams.put(PARAM_LABEL, null);
        macroParams.put(PARAM_ASSIGNABLE, "false");
        macroParams.put(PARAM_REMEMBERASSIGNEES, "false");
        macroParams.put(PARAM_APPROVELABEL, null);
        macroParams.put(PARAM_REJECTLABEL, null);
        macroParams.put(PARAM_DESCRIPTION, null);
        macroParams.put(PARAM_ROLES, "false");
        return macroParams;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String approvalName;
        if (!(renderContext instanceof PageContext)) {
            throw new MacroException("approvals can only be defined in Pages and Blogs");
        }
        AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        ArrayList flags = new ArrayList();
        Map macroParams = this.makeMacroParams();
        this.parseParameters(parameters, conditions, flags, macroParams, page);
        String string = approvalName = flags.size() > 0 ? (String)flags.get(0) : null;
        if (!TextUtils.stringSet((String)approvalName)) {
            throw new MacroException("must define an approval name");
        }
        try {
            String minRequiredApprovers;
            boolean assignable;
            int weight;
            HasViewWorkflowPermission viewWorkflowCondition = new HasViewWorkflowPermission(false, Boolean.TRUE.toString());
            conditions.add(viewWorkflowCondition);
            if (!Approval.isValidName(approvalName)) {
                throw new WorkflowUserException("approvalsworkflow.approvals.invalid-name", (Object)approvalName, Approval.getInvalidCharactersAsString());
            }
            String strWeight = (String)macroParams.get(PARAM_WEIGHT);
            try {
                weight = Integer.parseInt(strWeight);
            }
            catch (NumberFormatException e) {
                throw new MacroException("invalid weight value " + strWeight);
            }
            boolean finalApproval = ((String)macroParams.get(PARAM_FINAL)).equalsIgnoreCase("true");
            boolean showInPages = ((String)macroParams.get(PARAM_SHOWINPAGES)).equalsIgnoreCase("true");
            boolean showInBlogs = ((String)macroParams.get(PARAM_SHOWINBLOGS)).equalsIgnoreCase("true");
            if (this.conditionsContainsApproverCondition(conditions)) {
                assignable = false;
                minRequiredApprovers = "0";
            } else {
                assignable = MapUtils.getBooleanValue(macroParams, PARAM_ASSIGNABLE, false);
                minRequiredApprovers = MapUtils.getString(parameters, "minimum", "0");
            }
            String description = macroParams.get(PARAM_DESCRIPTION) != null ? macroParams.get(PARAM_DESCRIPTION).toString() : null;
            boolean rememberAssignees = MapUtils.getBooleanValue(macroParams, PARAM_REMEMBERASSIGNEES, false);
            boolean roles = MapUtils.getBooleanValue(macroParams, PARAM_ROLES, false);
            int credentials = SignatureType.NONE.getId();
            try {
                credentials = Integer.parseInt((String)macroParams.get(PARAM_CREDENTIALS));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (credentials > SignatureType.USERID_AND_PASSWORD.getId()) {
                credentials = SignatureType.USERID_AND_PASSWORD.getId();
            }
            String approveLabel = MapUtils.getString(macroParams, PARAM_APPROVELABEL);
            String rejectLabel = MapUtils.getString(macroParams, PARAM_REJECTLABEL);
            Approval approval = new Approval(approvalName, weight, conditions, finalApproval, showInPages, showInBlogs, credentials);
            approval.setAssignable(assignable);
            approval.setRememberAssignees(rememberAssignees);
            approval.setRoles(roles);
            approval.setMinRequiredApprovers(minRequiredApprovers);
            approval.setApproveLabel(approveLabel);
            approval.setRejectLabel(rejectLabel);
            approval.setBody(body);
            if (description != null) {
                approval.setDescription(description);
            }
            this.setLabel(approval, (String)parameters.get(PARAM_LABEL));
            List<WorkflowElement> elements = this.getElementsList(renderContext);
            elements.add(approval);
        }
        catch (WorkflowException e) {
            throw new MacroException("Error in approval " + approvalName + ": " + e.getMessage());
        }
        return "";
    }

    private boolean conditionsContainsApproverCondition(List<Condition> conditions) {
        for (Condition condition : conditions) {
            if (!(condition instanceof ApproverCondition)) continue;
            return true;
        }
        return false;
    }

    private void setLabel(Approval approval, String labelName) throws MacroException {
        if (!TextUtils.stringSet((String)labelName)) {
            return;
        }
        approval.setLabel(ApprovalMacro.parseLabel(labelName));
    }
}

