/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.dao;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.workflow.dao.ApprovalCheckDao;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultApprovalCheckDao
implements ApprovalCheckDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultApprovalCheckDao.class);
    public static final String LATEST_APPROVALS_KEY = "com.comalatech.workflow.approvals.latest";
    public static final String APPROVALS_KEY = "com.comalatech.workflow.approvals";
    public static final String FINAL_APPROVAL_KEY = "com.comalatech.workflow.approvals.final.key";
    public static final String FINAL_APPROVAL_ID_KEY = "com.comalatech.workflow.approvals.key";
    private static final String ATTACHMENT_ID_UPGRADE_KEY = "com.comalatech.workflow.attachmentIDs.updated";
    protected final UserAccessor userAccessor;
    private final ComalaPropertiesSetManager contentPropertyManager;

    public DefaultApprovalCheckDao(UserAccessor userAccessor, ComalaPropertiesSetManager contentPropertyManager) {
        this.userAccessor = userAccessor;
        this.contentPropertyManager = contentPropertyManager;
    }

    @Override
    public ApprovalCheck[] getLatestApprovalChecks(AbstractPage page) {
        String latestXml = this.getRawLatestApprovalChecks(page);
        if (TextUtils.stringSet((String)latestXml)) {
            return this.deserializeApprovals(page, latestXml, true);
        }
        return null;
    }

    @Override
    public ApprovalCheck[] getApprovalChecks(AbstractPage page) {
        String rawchecks = this.getRawChecks(page);
        if (!TextUtils.stringSet((String)rawchecks)) {
            return ApprovalCheck.EMPTY_ARRAY;
        }
        return this.deserializeApprovals(page, rawchecks, true);
    }

    @Override
    public void saveLatestApprovalChecks(AbstractPage page, ApprovalCheck[] latestApprovalChecks) {
        this.saveRawLatestApprovalChecks(page, this.serializeApprovals(latestApprovalChecks));
    }

    @Override
    public void saveApprovalChecks(AbstractPage page, ApprovalCheck[] approvals) {
        String xml;
        if (approvals == null || approvals.length == 0) {
            xml = null;
        } else {
            int i;
            xml = this.serializeApprovals(approvals);
            for (i = approvals.length - 1; i > 0 && approvals[i].getStateId() == approvals[i - 1].getStateId(); --i) {
            }
            int length = approvals.length - i;
            ApprovalCheck[] latestApprovalChecks = new ApprovalCheck[length];
            System.arraycopy(approvals, i, latestApprovalChecks, 0, length);
            this.saveRawLatestApprovalChecks(page, this.serializeApprovals(latestApprovalChecks));
        }
        this.saveRawApprovals(page, xml);
    }

    @Override
    public void removeApprovalChecks(AbstractPage page) {
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, APPROVALS_KEY);
    }

    protected abstract ApprovalCheck[] deserializeApprovals(AbstractPage var1, String var2, boolean var3);

    protected abstract ApprovalCheck deserializeApproval(AbstractPage var1, String var2, boolean var3);

    protected abstract String serializeApprovals(ApprovalCheck[] var1);

    protected abstract String serializeApproval(ApprovalCheck var1);

    @Override
    public Integer getFinalApprovalCheckId(AbstractPage page) {
        return NumberUtils.createInteger((String)this.contentPropertyManager.getStringProperty((ContentEntityObject)page, FINAL_APPROVAL_ID_KEY));
    }

    @Override
    public void setFinalApprovalCheckId(AbstractPage page, int approvalCheckId) {
        this.contentPropertyManager.setStringProperty((ContentEntityObject)page, FINAL_APPROVAL_ID_KEY, Integer.toString(approvalCheckId));
    }

    @Override
    public void clearFinalApprovalId(AbstractPage page) {
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, FINAL_APPROVAL_KEY);
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, FINAL_APPROVAL_ID_KEY);
    }

    private String getRawLatestApprovalChecks(AbstractPage page) {
        return this.contentPropertyManager.getTextProperty((ContentEntityObject)page, LATEST_APPROVALS_KEY);
    }

    private void saveRawLatestApprovalChecks(AbstractPage page, String xml) {
        this.contentPropertyManager.setTextProperty((ContentEntityObject)page, LATEST_APPROVALS_KEY, xml);
    }

    @Override
    public void removeLatestApprovalChecks(AbstractPage page) {
        this.contentPropertyManager.removeProperty((ContentEntityObject)page, LATEST_APPROVALS_KEY);
    }

    private String getRawChecks(AbstractPage page) {
        return this.contentPropertyManager.getTextProperty((ContentEntityObject)page, APPROVALS_KEY);
    }

    private void saveRawApprovals(AbstractPage page, String xml) {
        this.contentPropertyManager.setTextProperty((ContentEntityObject)page, APPROVALS_KEY, xml);
    }

    @Override
    public boolean isAttachmentIDsMigrated(AbstractPage page) {
        return this.contentPropertyManager.getStringProperty((ContentEntityObject)page, ATTACHMENT_ID_UPGRADE_KEY) != null;
    }

    @Override
    public void setAttachmentIDsMigrated(AbstractPage page) {
        this.contentPropertyManager.setStringProperty((ContentEntityObject)page, ATTACHMENT_ID_UPGRADE_KEY, Boolean.TRUE.toString());
    }
}

