/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.events.admin.WorkflowAdvancedConfigurationUpdatedEventImpl;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class WorkflowAdvancedConfigAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(WorkflowAdvancedConfigAction.class);
    private WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    private AdhocWorkflowsLicenseManager licenseManager;
    private EventPublisher eventPublisher;
    private GroupManager groupManager;
    private String confirm;
    private boolean editMode = true;
    private String errorMessage;
    private int cacheProductionWorkflows;
    private int cacheGlobalWorkflows;
    private int cacheGlobalWorkflowNames;
    private int userSearchMinCharacters;
    private int dataExtractorBatch;
    private int expirationJobBatch;
    private int maxHandledUsers;
    private int maxAllowedApproversToShow;
    private String impersonatorsGroup;
    private static final String docoUrl = "https://apps.appf.re/cdmdc/doc/advancedconfiguration/NkRu3W";

    public String view() {
        this.editMode = false;
        this.cacheGlobalWorkflowNames = this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflowNames();
        this.cacheGlobalWorkflows = this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflows();
        this.cacheProductionWorkflows = this.workflowAdvancedConfigurationManager.getCacheProductionWorkflows();
        this.userSearchMinCharacters = this.workflowAdvancedConfigurationManager.getUserSearchMinCharacters();
        this.dataExtractorBatch = this.workflowAdvancedConfigurationManager.getDataExtractorBatchSize();
        this.expirationJobBatch = this.workflowAdvancedConfigurationManager.getExpirationJobBatchSize();
        this.maxHandledUsers = this.workflowAdvancedConfigurationManager.getMaxHandledUsers();
        this.maxAllowedApproversToShow = this.workflowAdvancedConfigurationManager.getMaxAllowedApproversToShow();
        this.impersonatorsGroup = this.workflowAdvancedConfigurationManager.getAdminImpersonatorsGroup();
        return "success";
    }

    public String edit() {
        this.view();
        this.editMode = true;
        return "success";
    }

    public String save() {
        this.editMode = true;
        if (this.confirm == null) {
            return "success";
        }
        Map<String, String> existingConfig = this.createConfigMap();
        try {
            this.workflowAdvancedConfigurationManager.setCacheProductionWorkflows(this.cacheProductionWorkflows);
            this.workflowAdvancedConfigurationManager.setCacheGlobalWorkflows(this.cacheGlobalWorkflows);
            this.workflowAdvancedConfigurationManager.setCacheGlobalWorkflowNames(this.cacheGlobalWorkflowNames);
            this.workflowAdvancedConfigurationManager.setUserSearchMinCharacters(this.userSearchMinCharacters);
            this.workflowAdvancedConfigurationManager.setDataExtractorBatchSize(this.dataExtractorBatch);
            this.workflowAdvancedConfigurationManager.setExpirationJobBatchSize(this.expirationJobBatch);
            this.workflowAdvancedConfigurationManager.setMaxHandledUsers(this.maxHandledUsers);
            this.workflowAdvancedConfigurationManager.setMaxAllowedApproversToShow(this.maxAllowedApproversToShow);
            this.workflowAdvancedConfigurationManager.setAdminImpersonatorsGroup(this.impersonatorsGroup);
            this.errorMessage = null;
            Map<String, String> newConfig = this.createConfigMap();
            if (!existingConfig.equals(newConfig)) {
                WorkflowAdvancedConfigurationUpdatedEventImpl updateEvent = new WorkflowAdvancedConfigurationUpdatedEventImpl(existingConfig, newConfig);
                this.eventPublisher.publish((Object)updateEvent);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.editMode = true;
            this.errorMessage = "Internal error, check server logs";
        }
        return this.view();
    }

    protected Map<String, String> createConfigMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("cacheProductionWorkflows", Integer.valueOf(this.workflowAdvancedConfigurationManager.getCacheProductionWorkflows()).toString());
        configMap.put("cacheGlobalWorkflows", Integer.valueOf(this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflows()).toString());
        configMap.put("cacheWorkflowNames", Integer.valueOf(this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflowNames()).toString());
        configMap.put("userSearchMinCharacters", Integer.valueOf(this.workflowAdvancedConfigurationManager.getUserSearchMinCharacters()).toString());
        configMap.put("dataExtractorBatch", Integer.valueOf(this.workflowAdvancedConfigurationManager.getDataExtractorBatchSize()).toString());
        configMap.put("expirationJobBatch", Integer.valueOf(this.workflowAdvancedConfigurationManager.getExpirationJobBatchSize()).toString());
        configMap.put("maxHandledUsers", Integer.valueOf(this.workflowAdvancedConfigurationManager.getMaxHandledUsers()).toString());
        configMap.put("maxAllowedApproversToShow", Integer.valueOf(this.workflowAdvancedConfigurationManager.getMaxAllowedApproversToShow()).toString());
        configMap.put("impersonatorsGroup", this.workflowAdvancedConfigurationManager.getAdminImpersonatorsGroup());
        return configMap;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public String getImpersonatorsGroup() {
        return this.impersonatorsGroup;
    }

    public void setImpersonatorsGroup(String groupName) {
        Group group = null;
        try {
            group = this.groupManager.getGroup(groupName);
        }
        catch (EntityException e) {
            log.error("error trying to resolve group with name: " + groupName, (Throwable)e);
        }
        this.impersonatorsGroup = group != null ? group.getName() : "";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setCacheProductionWorkflows(int cacheProductionWorkflows) {
        this.cacheProductionWorkflows = cacheProductionWorkflows;
    }

    public void setCacheGlobalWorkflows(int cacheGlobalWorkflows) {
        this.cacheGlobalWorkflows = cacheGlobalWorkflows;
    }

    public void setCacheGlobalWorkflowNames(int cacheGlobalWorkflowNames) {
        this.cacheGlobalWorkflowNames = cacheGlobalWorkflowNames;
    }

    public void setUserSearchMinCharacters(int userSearchMinCharacters) {
        this.userSearchMinCharacters = userSearchMinCharacters;
    }

    public void setDataExtractorBatch(int dataExtractorBatch) {
        this.dataExtractorBatch = dataExtractorBatch;
    }

    public int getCacheProductionWorkflows() {
        return this.cacheProductionWorkflows;
    }

    public int getCacheGlobalWorkflows() {
        return this.cacheGlobalWorkflows;
    }

    public int getCacheGlobalWorkflowNames() {
        return this.cacheGlobalWorkflowNames;
    }

    public int getUserSearchMinCharacters() {
        return this.userSearchMinCharacters;
    }

    public int getDataExtractorBatch() {
        return this.dataExtractorBatch;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setWorkflowAdvancedConfigurationManager(WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager) {
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
    }

    public int getExpirationJobBatch() {
        return this.expirationJobBatch;
    }

    public void setExpirationJobBatch(int expirationJobBatch) {
        this.expirationJobBatch = expirationJobBatch;
    }

    public int getMaxHandledUsers() {
        return this.maxHandledUsers;
    }

    public void setMaxHandledUsers(int maxHandledUsers) {
        this.maxHandledUsers = maxHandledUsers;
    }

    public int getMaxAllowedApproversToShow() {
        return this.maxAllowedApproversToShow;
    }

    public void setMaxAllowedApproversToShow(int maxAllowedApproversToShow) {
        this.maxAllowedApproversToShow = maxAllowedApproversToShow;
    }

    public String getDocoUrl() {
        return docoUrl;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }
}

