/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.encryption.AESEncryptionException;
import com.comalatech.confluence.ipc.api.contracts.CredentialManager;
import com.comalatech.confluence.workflow.esignatures.ao.entity.BaseSigningTokenRecord;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.mapper.SigningTokenRecordMapper;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflow.esignatures.model.SigningTokenRegistry;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.esignatures.service.TOTPHelper;
import com.comalatech.workflow.WorkflowException;
import com.opensymphony.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalCredentialManager
implements CredentialManager {
    private static final Logger log = LoggerFactory.getLogger(ApprovalCredentialManager.class);
    private final ESignaturesConfigurationManager eSignaturesConfigurationManager;
    private final ESignaturesService eSignaturesService;
    private final UserAccessor userAccessor;
    private final SystemInformationService systemInformationService;
    private final DarkFeatureManager darkFeatureManager;

    public ApprovalCredentialManager(ESignaturesConfigurationManager eSignaturesConfigurationManager, ESignaturesService eSignaturesService, UserAccessor userAccessor, SystemInformationService systemInformationService, DarkFeatureManager darkFeatureManager) {
        this.eSignaturesConfigurationManager = eSignaturesConfigurationManager;
        this.eSignaturesService = eSignaturesService;
        this.userAccessor = userAccessor;
        this.systemInformationService = systemInformationService;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public boolean checkUserCredential(String user) {
        if (TextUtils.stringSet((String)user)) {
            return user.equalsIgnoreCase(AuthenticatedUserThreadLocal.getUsername());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkPasswordCredential(String password) throws WorkflowException {
        String userName = AuthenticatedUserThreadLocal.getUsername();
        if (TextUtils.stringSet((String)userName) && TextUtils.stringSet((String)password)) {
            String credentials = this.eSignaturesConfigurationManager.getESignaturesCredentials();
            if (credentials.equals(ESignatureCredentials.Credentials.CONFLUENCE.getValue())) {
                boolean authenticated;
                ConfluenceUser authenticatedUser = AuthenticatedUserThreadLocal.get();
                try {
                    authenticated = this.userAccessor.authenticate(userName, password);
                }
                finally {
                    if (AuthenticatedUserThreadLocal.get() == null) {
                        log.debug("AWP-8483: AuthenticatedUser is null after userAccessor.authenticate");
                        AuthenticatedUserThreadLocal.set((ConfluenceUser)authenticatedUser);
                    }
                }
                return authenticated;
            }
            if (credentials.equals(ESignatureCredentials.Credentials.OTP.getValue())) {
                BaseSigningTokenRecord baseSigningTokenRecord = this.getSigningTokenRecordApproval();
                if (baseSigningTokenRecord == null) {
                    return false;
                }
                TOTPHelper totpHelper = new TOTPHelper();
                boolean valid = totpHelper.isValid(baseSigningTokenRecord.getSecretKey(), password);
                this.updateSigningTokenRecord(valid, baseSigningTokenRecord);
                return valid;
            }
        }
        return false;
    }

    private void updateSigningTokenRecord(boolean isValidCredential, BaseSigningTokenRecord baseSigningTokenRecord) {
        SigningTokenRegistry signingTokenRegistry = SigningTokenRecordMapper.recordToSigningTokenRegistry(baseSigningTokenRecord);
        if (isValidCredential) {
            signingTokenRegistry.clearFailedAttempts();
        } else {
            signingTokenRegistry.updateFailedAttempts();
        }
        try {
            this.eSignaturesService.updateSigningTokeRecord(signingTokenRegistry);
        }
        catch (Exception e) {
            log.error("Could not update signing record when checking approval credentials! id : {}", (Object)baseSigningTokenRecord.getId(), (Object)e);
        }
    }

    private BaseSigningTokenRecord getSigningTokenRecordApproval() throws WorkflowException {
        BaseSigningTokenRecord baseSigningTokenRecord;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        try {
            baseSigningTokenRecord = this.eSignaturesService.getSigningTokenRecord(user.getKey().getStringValue());
        }
        catch (AESEncryptionException ex) {
            log.error("Error parsing user OTP secret key, removing key for user: " + user.getKey().getStringValue());
            this.eSignaturesService.purgeSigningToken(user.getKey().getStringValue());
            String errorMessage = ConfluenceActionSupport.getTextStatic((String)"comalatech.esignatures.signing.otp.error.encryption");
            throw new WorkflowException(errorMessage);
        }
        return baseSigningTokenRecord;
    }
}

