/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.BlogPostTaskDueDateCreatedEvent;
import com.comalatech.confluence.states.event.BlogPostTaskDueDateUpdatedEvent;
import com.comalatech.confluence.states.event.PageTaskDueDateCreatedEvent;
import com.comalatech.confluence.states.event.PageTaskDueDateUpdatedEvent;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;

public class TaskDueDateMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskDueDateMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageTaskDueDateCreatedEvent) {
            PageTaskDueDateCreatedEvent pageTaskDueDateCreatedEvent = (PageTaskDueDateCreatedEvent)event;
            return this.buildActivity((AbstractPage)pageTaskDueDateCreatedEvent.getPage(), (PageState)pageTaskDueDateCreatedEvent.getState(), (PageTask)pageTaskDueDateCreatedEvent.getTask());
        }
        if (event instanceof BlogPostTaskDueDateCreatedEvent) {
            BlogPostTaskDueDateCreatedEvent blogPostTaskDueDateCreatedEvent = (BlogPostTaskDueDateCreatedEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskDueDateCreatedEvent.getBlogPost(), (PageState)blogPostTaskDueDateCreatedEvent.getState(), (PageTask)blogPostTaskDueDateCreatedEvent.getTask());
        }
        if (event instanceof PageTaskDueDateUpdatedEvent) {
            PageTaskDueDateUpdatedEvent pageTaskDueDateUpdatedEvent = (PageTaskDueDateUpdatedEvent)event;
            return this.buildActivity((AbstractPage)pageTaskDueDateUpdatedEvent.getPage(), (PageState)pageTaskDueDateUpdatedEvent.getState(), (PageTask)pageTaskDueDateUpdatedEvent.getTask());
        }
        if (event instanceof BlogPostTaskDueDateUpdatedEvent) {
            BlogPostTaskDueDateUpdatedEvent blogPostTaskDueDateUpdatedEvent = (BlogPostTaskDueDateUpdatedEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskDueDateUpdatedEvent.getBlogPost(), (PageState)blogPostTaskDueDateUpdatedEvent.getState(), (PageTask)blogPostTaskDueDateUpdatedEvent.getTask());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask) throws WorkflowUserException {
        return this.buildActivity(abstractPage, state, pageTask, pageTask.getCurrentDueDate());
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask, DueDateRecord dueDateRecord) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(dueDateRecord.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetail.Type.TASK_NAME, pageTask.getName());
        details.addDetail(ActionDetail.Type.TASK_DUE_DATE, String.valueOf(dueDateRecord.getDueDate().getTime()));
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_DUE_DATE), actor, details);
        return new Activity(TaskDueDateMapper.buildTarget((ContentEntityObject)abstractPage), dueDateRecord.getDate().getTime(), action);
    }
}

