/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder;

import com.comalatech.confluence.documentActivity.ao.accesor.builder.FilterBuilder;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.license.WorkflowsFeatureManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;

public class UsersFilterBuilder
implements FilterBuilder {
    @Override
    public Query build(DocumentActivityQuery query) {
        if (this.shouldApply(query)) {
            StringBuilder clause = new StringBuilder();
            ArrayList clauseParams = new ArrayList();
            List<String> recordIdsFromParticipants = null;
            List<String> recordIdsFromUsers = null;
            if (query.getFilters().getParticipant() != null) {
                List<String> list = recordIdsFromParticipants = query.getFilters().getRecordIdsFromParticipants() != null ? query.getFilters().getRecordIdsFromParticipants() : Collections.emptyList();
            }
            if (query.getFilters().getUser() != null) {
                recordIdsFromUsers = query.getFilters().getRecordIdsFromUsers() != null ? query.getFilters().getRecordIdsFromUsers() : Collections.emptyList();
            }
            Stream.of(this.getActorsQuery(query.getFilters().getActor()), this.getParticipantsQuery(recordIdsFromParticipants), this.getUsersQuery(query.getFilters().getUser(), recordIdsFromUsers)).filter(Objects::nonNull).forEach(userQuery -> {
                if (!clause.toString().isEmpty()) {
                    clause.append(" AND ");
                }
                clause.append(userQuery.getWhereClause());
                Collections.addAll(clauseParams, userQuery.getWhereParams());
            });
            if (!StringUtils.isEmpty((CharSequence)clause)) {
                return Query.select().where(clause.toString(), clauseParams.toArray());
            }
        }
        return null;
    }

    @Override
    public boolean shouldApply(DocumentActivityQuery query) {
        return this.shouldApplyToActors(query) || this.shouldApplyToParticipants(query) || this.shouldApplyToUsers(query);
    }

    public boolean shouldApplyToActors(DocumentActivityQuery query) {
        return query.getFilters() != null && query.getFilters().getActor() != null && !query.getFilters().getActor().isEmpty();
    }

    public boolean shouldApplyToParticipants(DocumentActivityQuery query) {
        return query.getFilters() != null && query.getFilters().getParticipant() != null && !query.getFilters().getParticipant().isEmpty();
    }

    public boolean shouldApplyToUsers(DocumentActivityQuery query) {
        return query.getFilters() != null && query.getFilters().getUser() != null && !query.getFilters().getUser().isEmpty();
    }

    private Query getActorsQuery(List<String> actors) {
        if (actors != null) {
            StringBuilder clause = new StringBuilder();
            if (actors.removeIf(WorkflowsFeatureManagerImpl::isWorkflowsUser)) {
                actors.addAll(Arrays.asList("com.comalatech.workflow", "com.comalatech.cloud.approvals", "com.comalatech.workflow.approvals"));
            }
            String placeHolder = actors.stream().map(s -> "?").collect(Collectors.joining(","));
            clause.append("ACTOR_ID IN (").append(StringUtils.isEmpty((CharSequence)placeHolder) ? "'NO_ACTOR'" : placeHolder).append(")");
            return Query.select().where(clause.toString(), actors.toArray());
        }
        return null;
    }

    private Query getParticipantsQuery(List<String> participantIds) {
        if (participantIds != null) {
            StringBuilder clause = new StringBuilder();
            String userKeyPlaceHolder = participantIds.stream().map(s -> "?").collect(Collectors.joining(","));
            clause.append("ID IN (").append(StringUtils.isEmpty((CharSequence)userKeyPlaceHolder) ? "'NO_PARTICIPANTS'" : userKeyPlaceHolder).append(")");
            return Query.select().where(clause.toString(), participantIds.toArray());
        }
        return null;
    }

    private Query getUsersQuery(List<String> users, List<String> participantIds) {
        boolean hasParticipants;
        boolean hasUsers = users != null && !users.isEmpty();
        boolean bl = hasParticipants = participantIds != null && !participantIds.isEmpty();
        if (hasUsers && hasParticipants) {
            if (users.removeIf(WorkflowsFeatureManagerImpl::isWorkflowsUser)) {
                users.addAll(Arrays.asList("com.comalatech.workflow", "com.comalatech.cloud.approvals", "com.comalatech.workflow.approvals"));
            }
            Query actorsQuery = this.getActorsQuery(users);
            Query participantsQuery = this.getParticipantsQuery(participantIds);
            String clause = "(" + actorsQuery.getWhereClause() + " OR " + participantsQuery.getWhereClause() + ")";
            ArrayList params = new ArrayList();
            Collections.addAll(params, actorsQuery.getWhereParams());
            Collections.addAll(params, participantsQuery.getWhereParams());
            return Query.select().where(clause, params.toArray());
        }
        if (hasUsers) {
            return this.getActorsQuery(users);
        }
        if (hasParticipants) {
            return this.getParticipantsQuery(participantIds);
        }
        return null;
    }
}

